/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.AccountType;
import io.moov.sdk.models.components.CapabilityID;
import io.moov.sdk.models.components.CapabilityStatus;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class ListAccountsRequest {

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-moov-version")
    private Optional<String> xMoovVersion;

    /**
     * Filter connected accounts by name.
     * 
     * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
     * &lt;ul&gt;
     *   &lt;li&gt;Account `displayName`&lt;/li&gt;
     *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
     *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
     * &lt;/ul&gt;
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=name")
    private Optional<String> name;

    /**
     * Filter connected accounts by email address.
     * 
     * <p>  Provide the full email address to filter by email.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=email")
    private Optional<String> email;

    /**
     * Filter connected accounts by AccountType.
     * 
     * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
     *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
     *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=type")
    private Optional<? extends AccountType> type;

    /**
     * Filter accounts with AccountType guest.
     * 
     * <p>  If true, the response will include guest accounts.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=includeGuest")
    private Optional<Boolean> includeGuest;

    /**
     * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=foreignID")
    private Optional<String> foreignID;

    /**
     * Filter disconnected accounts.
     * 
     * <p>If true, the response will include disconnected accounts.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=includeDisconnected")
    private Optional<Boolean> includeDisconnected;

    /**
     * Filter connected accounts by the capability.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=capability")
    private Optional<? extends CapabilityID> capability;

    /**
     * Filter connected accounts by the capability.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=capabilityStatus")
    private Optional<? extends CapabilityStatus> capabilityStatus;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;

    @JsonCreator
    public ListAccountsRequest(
            Optional<String> xMoovVersion,
            Optional<String> name,
            Optional<String> email,
            Optional<? extends AccountType> type,
            Optional<Boolean> includeGuest,
            Optional<String> foreignID,
            Optional<Boolean> includeDisconnected,
            Optional<? extends CapabilityID> capability,
            Optional<? extends CapabilityStatus> capabilityStatus,
            Optional<Long> skip,
            Optional<Long> count) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(includeGuest, "includeGuest");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(includeDisconnected, "includeDisconnected");
        Utils.checkNotNull(capability, "capability");
        Utils.checkNotNull(capabilityStatus, "capabilityStatus");
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        this.xMoovVersion = xMoovVersion;
        this.name = name;
        this.email = email;
        this.type = type;
        this.includeGuest = includeGuest;
        this.foreignID = foreignID;
        this.includeDisconnected = includeDisconnected;
        this.capability = capability;
        this.capabilityStatus = capabilityStatus;
        this.skip = skip;
        this.count = count;
    }
    
    public ListAccountsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @JsonIgnore
    public Optional<String> xMoovVersion() {
        return xMoovVersion;
    }

    /**
     * Filter connected accounts by name.
     * 
     * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
     * &lt;ul&gt;
     *   &lt;li&gt;Account `displayName`&lt;/li&gt;
     *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
     *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
     * &lt;/ul&gt;
     */
    @JsonIgnore
    public Optional<String> name() {
        return name;
    }

    /**
     * Filter connected accounts by email address.
     * 
     * <p>  Provide the full email address to filter by email.
     */
    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    /**
     * Filter connected accounts by AccountType.
     * 
     * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
     *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
     *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountType> type() {
        return (Optional<AccountType>) type;
    }

    /**
     * Filter accounts with AccountType guest.
     * 
     * <p>  If true, the response will include guest accounts.
     */
    @JsonIgnore
    public Optional<Boolean> includeGuest() {
        return includeGuest;
    }

    /**
     * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
     */
    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    /**
     * Filter disconnected accounts.
     * 
     * <p>If true, the response will include disconnected accounts.
     */
    @JsonIgnore
    public Optional<Boolean> includeDisconnected() {
        return includeDisconnected;
    }

    /**
     * Filter connected accounts by the capability.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CapabilityID> capability() {
        return (Optional<CapabilityID>) capability;
    }

    /**
     * Filter connected accounts by the capability.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CapabilityStatus> capabilityStatus() {
        return (Optional<CapabilityStatus>) capabilityStatus;
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListAccountsRequest withXMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.ofNullable(xMoovVersion);
        return this;
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public ListAccountsRequest withXMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    /**
     * Filter connected accounts by name.
     * 
     * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
     * &lt;ul&gt;
     *   &lt;li&gt;Account `displayName`&lt;/li&gt;
     *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
     *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
     * &lt;/ul&gt;
     */
    public ListAccountsRequest withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    /**
     * Filter connected accounts by name.
     * 
     * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
     * &lt;ul&gt;
     *   &lt;li&gt;Account `displayName`&lt;/li&gt;
     *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
     *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
     * &lt;/ul&gt;
     */
    public ListAccountsRequest withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Filter connected accounts by email address.
     * 
     * <p>  Provide the full email address to filter by email.
     */
    public ListAccountsRequest withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    /**
     * Filter connected accounts by email address.
     * 
     * <p>  Provide the full email address to filter by email.
     */
    public ListAccountsRequest withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    /**
     * Filter connected accounts by AccountType.
     * 
     * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
     *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
     *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
     */
    public ListAccountsRequest withType(AccountType type) {
        Utils.checkNotNull(type, "type");
        this.type = Optional.ofNullable(type);
        return this;
    }

    /**
     * Filter connected accounts by AccountType.
     * 
     * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
     *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
     *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
     */
    public ListAccountsRequest withType(Optional<? extends AccountType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Filter accounts with AccountType guest.
     * 
     * <p>  If true, the response will include guest accounts.
     */
    public ListAccountsRequest withIncludeGuest(boolean includeGuest) {
        Utils.checkNotNull(includeGuest, "includeGuest");
        this.includeGuest = Optional.ofNullable(includeGuest);
        return this;
    }

    /**
     * Filter accounts with AccountType guest.
     * 
     * <p>  If true, the response will include guest accounts.
     */
    public ListAccountsRequest withIncludeGuest(Optional<Boolean> includeGuest) {
        Utils.checkNotNull(includeGuest, "includeGuest");
        this.includeGuest = includeGuest;
        return this;
    }

    /**
     * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
     */
    public ListAccountsRequest withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }

    /**
     * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
     */
    public ListAccountsRequest withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    /**
     * Filter disconnected accounts.
     * 
     * <p>If true, the response will include disconnected accounts.
     */
    public ListAccountsRequest withIncludeDisconnected(boolean includeDisconnected) {
        Utils.checkNotNull(includeDisconnected, "includeDisconnected");
        this.includeDisconnected = Optional.ofNullable(includeDisconnected);
        return this;
    }

    /**
     * Filter disconnected accounts.
     * 
     * <p>If true, the response will include disconnected accounts.
     */
    public ListAccountsRequest withIncludeDisconnected(Optional<Boolean> includeDisconnected) {
        Utils.checkNotNull(includeDisconnected, "includeDisconnected");
        this.includeDisconnected = includeDisconnected;
        return this;
    }

    /**
     * Filter connected accounts by the capability.
     */
    public ListAccountsRequest withCapability(CapabilityID capability) {
        Utils.checkNotNull(capability, "capability");
        this.capability = Optional.ofNullable(capability);
        return this;
    }

    /**
     * Filter connected accounts by the capability.
     */
    public ListAccountsRequest withCapability(Optional<? extends CapabilityID> capability) {
        Utils.checkNotNull(capability, "capability");
        this.capability = capability;
        return this;
    }

    /**
     * Filter connected accounts by the capability.
     */
    public ListAccountsRequest withCapabilityStatus(CapabilityStatus capabilityStatus) {
        Utils.checkNotNull(capabilityStatus, "capabilityStatus");
        this.capabilityStatus = Optional.ofNullable(capabilityStatus);
        return this;
    }

    /**
     * Filter connected accounts by the capability.
     */
    public ListAccountsRequest withCapabilityStatus(Optional<? extends CapabilityStatus> capabilityStatus) {
        Utils.checkNotNull(capabilityStatus, "capabilityStatus");
        this.capabilityStatus = capabilityStatus;
        return this;
    }

    public ListAccountsRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }

    public ListAccountsRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListAccountsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }

    public ListAccountsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListAccountsRequest other = (ListAccountsRequest) o;
        return 
            Objects.deepEquals(this.xMoovVersion, other.xMoovVersion) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.includeGuest, other.includeGuest) &&
            Objects.deepEquals(this.foreignID, other.foreignID) &&
            Objects.deepEquals(this.includeDisconnected, other.includeDisconnected) &&
            Objects.deepEquals(this.capability, other.capability) &&
            Objects.deepEquals(this.capabilityStatus, other.capabilityStatus) &&
            Objects.deepEquals(this.skip, other.skip) &&
            Objects.deepEquals(this.count, other.count);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xMoovVersion,
            name,
            email,
            type,
            includeGuest,
            foreignID,
            includeDisconnected,
            capability,
            capabilityStatus,
            skip,
            count);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListAccountsRequest.class,
                "xMoovVersion", xMoovVersion,
                "name", name,
                "email", email,
                "type", type,
                "includeGuest", includeGuest,
                "foreignID", foreignID,
                "includeDisconnected", includeDisconnected,
                "capability", capability,
                "capabilityStatus", capabilityStatus,
                "skip", skip,
                "count", count);
    }
    
    public final static class Builder {
 
        private Optional<String> xMoovVersion;
 
        private Optional<String> name = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends AccountType> type = Optional.empty();
 
        private Optional<Boolean> includeGuest = Optional.empty();
 
        private Optional<String> foreignID = Optional.empty();
 
        private Optional<Boolean> includeDisconnected = Optional.empty();
 
        private Optional<? extends CapabilityID> capability = Optional.empty();
 
        private Optional<? extends CapabilityStatus> capabilityStatus = Optional.empty();
 
        private Optional<Long> skip = Optional.empty();
 
        private Optional<Long> count = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = Optional.ofNullable(xMoovVersion);
            return this;
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(Optional<String> xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = xMoovVersion;
            return this;
        }

        /**
         * Filter connected accounts by name.
         * 
         * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
         * &lt;ul&gt;
         *   &lt;li&gt;Account `displayName`&lt;/li&gt;
         *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
         *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
         * &lt;/ul&gt;
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * Filter connected accounts by name.
         * 
         * <p>If provided, this query will attempt to find matches against the following Account and Profile fields:
         * &lt;ul&gt;
         *   &lt;li&gt;Account `displayName`&lt;/li&gt;
         *   &lt;li&gt;Individual Profile `firstName`, `middleName`, and `lastName`&lt;/li&gt;
         *   &lt;li&gt;Business Profile `legalBusinessName`&lt;/li&gt;
         * &lt;/ul&gt;
         */
        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Filter connected accounts by email address.
         * 
         * <p>  Provide the full email address to filter by email.
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * Filter connected accounts by email address.
         * 
         * <p>  Provide the full email address to filter by email.
         */
        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        /**
         * Filter connected accounts by AccountType.
         * 
         * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
         *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
         *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
         */
        public Builder type(AccountType type) {
            Utils.checkNotNull(type, "type");
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * Filter connected accounts by AccountType.
         * 
         * <p>  If the `type` parameter is used in combination with `name`, only the corresponding type's name fields will
         *   be searched. For example, if `type=business` and `name=moov`, the search will attempt to find matches against
         *   the display name and Business Profile name fields (`legalBusinessName`, and `doingBusinessAs`).
         */
        public Builder type(Optional<? extends AccountType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * Filter accounts with AccountType guest.
         * 
         * <p>  If true, the response will include guest accounts.
         */
        public Builder includeGuest(boolean includeGuest) {
            Utils.checkNotNull(includeGuest, "includeGuest");
            this.includeGuest = Optional.ofNullable(includeGuest);
            return this;
        }

        /**
         * Filter accounts with AccountType guest.
         * 
         * <p>  If true, the response will include guest accounts.
         */
        public Builder includeGuest(Optional<Boolean> includeGuest) {
            Utils.checkNotNull(includeGuest, "includeGuest");
            this.includeGuest = includeGuest;
            return this;
        }

        /**
         * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        /**
         * Serves as an optional alias from a foreign/external system which can be used to reference this resource.
         */
        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        /**
         * Filter disconnected accounts.
         * 
         * <p>If true, the response will include disconnected accounts.
         */
        public Builder includeDisconnected(boolean includeDisconnected) {
            Utils.checkNotNull(includeDisconnected, "includeDisconnected");
            this.includeDisconnected = Optional.ofNullable(includeDisconnected);
            return this;
        }

        /**
         * Filter disconnected accounts.
         * 
         * <p>If true, the response will include disconnected accounts.
         */
        public Builder includeDisconnected(Optional<Boolean> includeDisconnected) {
            Utils.checkNotNull(includeDisconnected, "includeDisconnected");
            this.includeDisconnected = includeDisconnected;
            return this;
        }

        /**
         * Filter connected accounts by the capability.
         */
        public Builder capability(CapabilityID capability) {
            Utils.checkNotNull(capability, "capability");
            this.capability = Optional.ofNullable(capability);
            return this;
        }

        /**
         * Filter connected accounts by the capability.
         */
        public Builder capability(Optional<? extends CapabilityID> capability) {
            Utils.checkNotNull(capability, "capability");
            this.capability = capability;
            return this;
        }

        /**
         * Filter connected accounts by the capability.
         */
        public Builder capabilityStatus(CapabilityStatus capabilityStatus) {
            Utils.checkNotNull(capabilityStatus, "capabilityStatus");
            this.capabilityStatus = Optional.ofNullable(capabilityStatus);
            return this;
        }

        /**
         * Filter connected accounts by the capability.
         */
        public Builder capabilityStatus(Optional<? extends CapabilityStatus> capabilityStatus) {
            Utils.checkNotNull(capabilityStatus, "capabilityStatus");
            this.capabilityStatus = capabilityStatus;
            return this;
        }

        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }

        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }
        
        public ListAccountsRequest build() {
            if (xMoovVersion == null) {
                xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
            }
            return new ListAccountsRequest(
                xMoovVersion,
                name,
                email,
                type,
                includeGuest,
                foreignID,
                includeDisconnected,
                capability,
                capabilityStatus,
                skip,
                count);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
                new LazySingletonValue<>(
                        "x-moov-version",
                        "\"v2024.01.00\"",
                        new TypeReference<Optional<String>>() {});
    }
}
