/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.QRCode;
import io.moov.sdk.utils.Response;
import io.moov.sdk.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GetPaymentLinkQRCodeResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The request has succeeded.
     */
    private Optional<? extends QRCode> qrCode;

    /**
     * The request has succeeded.
     */
    private Optional<? extends InputStream> responseStream;

    private Map<String, List<String>> headers;

    @JsonCreator
    public GetPaymentLinkQRCodeResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends QRCode> qrCode,
            Optional<? extends InputStream> responseStream,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(qrCode, "qrCode");
        Utils.checkNotNull(responseStream, "responseStream");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.qrCode = qrCode;
        this.responseStream = responseStream;
        this.headers = headers;
    }
    
    public GetPaymentLinkQRCodeResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The request has succeeded.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<QRCode> qrCode() {
        return (Optional<QRCode>) qrCode;
    }

    /**
     * The request has succeeded.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<InputStream> responseStream() {
        return (Optional<InputStream>) responseStream;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public GetPaymentLinkQRCodeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public GetPaymentLinkQRCodeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public GetPaymentLinkQRCodeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The request has succeeded.
     */
    public GetPaymentLinkQRCodeResponse withQRCode(QRCode qrCode) {
        Utils.checkNotNull(qrCode, "qrCode");
        this.qrCode = Optional.ofNullable(qrCode);
        return this;
    }

    /**
     * The request has succeeded.
     */
    public GetPaymentLinkQRCodeResponse withQRCode(Optional<? extends QRCode> qrCode) {
        Utils.checkNotNull(qrCode, "qrCode");
        this.qrCode = qrCode;
        return this;
    }

    /**
     * The request has succeeded.
     */
    public GetPaymentLinkQRCodeResponse withResponseStream(InputStream responseStream) {
        Utils.checkNotNull(responseStream, "responseStream");
        this.responseStream = Optional.ofNullable(responseStream);
        return this;
    }

    /**
     * The request has succeeded.
     */
    public GetPaymentLinkQRCodeResponse withResponseStream(Optional<? extends InputStream> responseStream) {
        Utils.checkNotNull(responseStream, "responseStream");
        this.responseStream = responseStream;
        return this;
    }

    public GetPaymentLinkQRCodeResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetPaymentLinkQRCodeResponse other = (GetPaymentLinkQRCodeResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.qrCode, other.qrCode) &&
            Objects.deepEquals(this.responseStream, other.responseStream) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            qrCode,
            responseStream,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetPaymentLinkQRCodeResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "qrCode", qrCode,
                "responseStream", responseStream,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends QRCode> qrCode = Optional.empty();
 
        private Optional<? extends InputStream> responseStream = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The request has succeeded.
         */
        public Builder qrCode(QRCode qrCode) {
            Utils.checkNotNull(qrCode, "qrCode");
            this.qrCode = Optional.ofNullable(qrCode);
            return this;
        }

        /**
         * The request has succeeded.
         */
        public Builder qrCode(Optional<? extends QRCode> qrCode) {
            Utils.checkNotNull(qrCode, "qrCode");
            this.qrCode = qrCode;
            return this;
        }

        /**
         * The request has succeeded.
         */
        public Builder responseStream(InputStream responseStream) {
            Utils.checkNotNull(responseStream, "responseStream");
            this.responseStream = Optional.ofNullable(responseStream);
            return this;
        }

        /**
         * The request has succeeded.
         */
        public Builder responseStream(Optional<? extends InputStream> responseStream) {
            Utils.checkNotNull(responseStream, "responseStream");
            this.responseStream = responseStream;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public GetPaymentLinkQRCodeResponse build() {
            return new GetPaymentLinkQRCodeResponse(
                contentType,
                statusCode,
                rawResponse,
                qrCode,
                responseStream,
                headers);
        }
    }
}
