/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.moov.sdk.models.components.CreateReversal;
import io.moov.sdk.utils.LazySingletonValue;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class CreateReversalRequest {

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-moov-version")
    private Optional<String> xMoovVersion;

    /**
     * Prevents duplicate reversals from being created.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-idempotency-key")
    private String xIdempotencyKey;

    /**
     * The Moov account ID.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * The transfer ID to reverse.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private Optional<? extends CreateReversal> createReversal;

    @JsonCreator
    public CreateReversalRequest(
            Optional<String> xMoovVersion,
            String xIdempotencyKey,
            String accountID,
            String transferID,
            Optional<? extends CreateReversal> createReversal) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(createReversal, "createReversal");
        this.xMoovVersion = xMoovVersion;
        this.xIdempotencyKey = xIdempotencyKey;
        this.accountID = accountID;
        this.transferID = transferID;
        this.createReversal = createReversal;
    }
    
    public CreateReversalRequest(
            String xIdempotencyKey,
            String accountID,
            String transferID) {
        this(Optional.empty(), xIdempotencyKey, accountID, transferID, Optional.empty());
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    @JsonIgnore
    public Optional<String> xMoovVersion() {
        return xMoovVersion;
    }

    /**
     * Prevents duplicate reversals from being created.
     */
    @JsonIgnore
    public String xIdempotencyKey() {
        return xIdempotencyKey;
    }

    /**
     * The Moov account ID.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * The transfer ID to reverse.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateReversal> createReversal() {
        return (Optional<CreateReversal>) createReversal;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public CreateReversalRequest withXMoovVersion(String xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = Optional.ofNullable(xMoovVersion);
        return this;
    }

    /**
     * Specify an API version.
     * 
     * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
     *   - `YYYY` is the year
     *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
     *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
     *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
     * 
     * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
     */
    public CreateReversalRequest withXMoovVersion(Optional<String> xMoovVersion) {
        Utils.checkNotNull(xMoovVersion, "xMoovVersion");
        this.xMoovVersion = xMoovVersion;
        return this;
    }

    /**
     * Prevents duplicate reversals from being created.
     */
    public CreateReversalRequest withXIdempotencyKey(String xIdempotencyKey) {
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        this.xIdempotencyKey = xIdempotencyKey;
        return this;
    }

    /**
     * The Moov account ID.
     */
    public CreateReversalRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * The transfer ID to reverse.
     */
    public CreateReversalRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public CreateReversalRequest withCreateReversal(CreateReversal createReversal) {
        Utils.checkNotNull(createReversal, "createReversal");
        this.createReversal = Optional.ofNullable(createReversal);
        return this;
    }

    public CreateReversalRequest withCreateReversal(Optional<? extends CreateReversal> createReversal) {
        Utils.checkNotNull(createReversal, "createReversal");
        this.createReversal = createReversal;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateReversalRequest other = (CreateReversalRequest) o;
        return 
            Objects.deepEquals(this.xMoovVersion, other.xMoovVersion) &&
            Objects.deepEquals(this.xIdempotencyKey, other.xIdempotencyKey) &&
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.createReversal, other.createReversal);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xMoovVersion,
            xIdempotencyKey,
            accountID,
            transferID,
            createReversal);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateReversalRequest.class,
                "xMoovVersion", xMoovVersion,
                "xIdempotencyKey", xIdempotencyKey,
                "accountID", accountID,
                "transferID", transferID,
                "createReversal", createReversal);
    }
    
    public final static class Builder {
 
        private Optional<String> xMoovVersion;
 
        private String xIdempotencyKey;
 
        private String accountID;
 
        private String transferID;
 
        private Optional<? extends CreateReversal> createReversal = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(String xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = Optional.ofNullable(xMoovVersion);
            return this;
        }

        /**
         * Specify an API version.
         * 
         * <p>API versioning follows the format `vYYYY.QQ.BB`, where 
         *   - `YYYY` is the year
         *   - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
         *   - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter. 
         *     - For example, `v2024.01.00` is the initial release of the first quarter of 2024.
         * 
         * <p>The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
         */
        public Builder xMoovVersion(Optional<String> xMoovVersion) {
            Utils.checkNotNull(xMoovVersion, "xMoovVersion");
            this.xMoovVersion = xMoovVersion;
            return this;
        }

        /**
         * Prevents duplicate reversals from being created.
         */
        public Builder xIdempotencyKey(String xIdempotencyKey) {
            Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
            this.xIdempotencyKey = xIdempotencyKey;
            return this;
        }

        /**
         * The Moov account ID.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        /**
         * The transfer ID to reverse.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder createReversal(CreateReversal createReversal) {
            Utils.checkNotNull(createReversal, "createReversal");
            this.createReversal = Optional.ofNullable(createReversal);
            return this;
        }

        public Builder createReversal(Optional<? extends CreateReversal> createReversal) {
            Utils.checkNotNull(createReversal, "createReversal");
            this.createReversal = createReversal;
            return this;
        }
        
        public CreateReversalRequest build() {
            if (xMoovVersion == null) {
                xMoovVersion = _SINGLETON_VALUE_XMoovVersion.value();
            }
            return new CreateReversalRequest(
                xMoovVersion,
                xIdempotencyKey,
                accountID,
                transferID,
                createReversal);
        }

        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_XMoovVersion =
                new LazySingletonValue<>(
                        "x-moov-version",
                        "\"v2024.01.00\"",
                        new TypeReference<Optional<String>>() {});
    }
}
