/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class RevokeTokenRequestError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("token")
    private Optional<String> token;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("token_type_hint")
    private Optional<String> tokenTypeHint;

    @JsonCreator
    public RevokeTokenRequestError(
            @JsonProperty("token") Optional<String> token,
            @JsonProperty("token_type_hint") Optional<String> tokenTypeHint) {
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.token = token;
        this.tokenTypeHint = tokenTypeHint;
    }
    
    public RevokeTokenRequestError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> token() {
        return token;
    }

    @JsonIgnore
    public Optional<String> tokenTypeHint() {
        return tokenTypeHint;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public RevokeTokenRequestError withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public RevokeTokenRequestError withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public RevokeTokenRequestError withTokenTypeHint(String tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = Optional.ofNullable(tokenTypeHint);
        return this;
    }

    public RevokeTokenRequestError withTokenTypeHint(Optional<String> tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = tokenTypeHint;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RevokeTokenRequestError other = (RevokeTokenRequestError) o;
        return 
            Objects.deepEquals(this.token, other.token) &&
            Objects.deepEquals(this.tokenTypeHint, other.tokenTypeHint);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            token,
            tokenTypeHint);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RevokeTokenRequestError.class,
                "token", token,
                "tokenTypeHint", tokenTypeHint);
    }
    
    public final static class Builder {
 
        private Optional<String> token = Optional.empty();
 
        private Optional<String> tokenTypeHint = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder tokenTypeHint(String tokenTypeHint) {
            Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
            this.tokenTypeHint = Optional.ofNullable(tokenTypeHint);
            return this;
        }

        public Builder tokenTypeHint(Optional<String> tokenTypeHint) {
            Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
            this.tokenTypeHint = tokenTypeHint;
            return this;
        }
        
        public RevokeTokenRequestError build() {
            return new RevokeTokenRequestError(
                token,
                tokenTypeHint);
        }
    }
}

