/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class RefundValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private Optional<String> amount;

    /**
     * Used for generic errors when invalid request data isn't attributed to a single request field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;

    @JsonCreator
    public RefundValidationError(
            @JsonProperty("amount") Optional<String> amount,
            @JsonProperty("error") Optional<String> error) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(error, "error");
        this.amount = amount;
        this.error = error;
    }
    
    public RefundValidationError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> amount() {
        return amount;
    }

    /**
     * Used for generic errors when invalid request data isn't attributed to a single request field.
     */
    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public RefundValidationError withAmount(String amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = Optional.ofNullable(amount);
        return this;
    }

    public RefundValidationError withAmount(Optional<String> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * Used for generic errors when invalid request data isn't attributed to a single request field.
     */
    public RefundValidationError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }

    /**
     * Used for generic errors when invalid request data isn't attributed to a single request field.
     */
    public RefundValidationError withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RefundValidationError other = (RefundValidationError) o;
        return 
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.error, other.error);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            amount,
            error);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RefundValidationError.class,
                "amount", amount,
                "error", error);
    }
    
    public final static class Builder {
 
        private Optional<String> amount = Optional.empty();
 
        private Optional<String> error = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder amount(String amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = Optional.ofNullable(amount);
            return this;
        }

        public Builder amount(Optional<String> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        /**
         * Used for generic errors when invalid request data isn't attributed to a single request field.
         */
        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        /**
         * Used for generic errors when invalid request data isn't attributed to a single request field.
         */
        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }
        
        public RefundValidationError build() {
            return new RefundValidationError(
                amount,
                error);
        }
    }
}

