/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class OnboardingInviteError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("returnURL")
    private Optional<String> returnURL;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("termsOfServiceURL")
    private Optional<String> termsOfServiceURL;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("scopes")
    private Optional<? extends Map<String, String>> scopes;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("capabilities")
    private Optional<? extends Map<String, String>> capabilities;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feePlanCodes")
    private Optional<? extends Map<String, String>> feePlanCodes;

    @JsonCreator
    public OnboardingInviteError(
            @JsonProperty("returnURL") Optional<String> returnURL,
            @JsonProperty("termsOfServiceURL") Optional<String> termsOfServiceURL,
            @JsonProperty("scopes") Optional<? extends Map<String, String>> scopes,
            @JsonProperty("capabilities") Optional<? extends Map<String, String>> capabilities,
            @JsonProperty("feePlanCodes") Optional<? extends Map<String, String>> feePlanCodes) {
        Utils.checkNotNull(returnURL, "returnURL");
        Utils.checkNotNull(termsOfServiceURL, "termsOfServiceURL");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(capabilities, "capabilities");
        Utils.checkNotNull(feePlanCodes, "feePlanCodes");
        this.returnURL = returnURL;
        this.termsOfServiceURL = termsOfServiceURL;
        this.scopes = scopes;
        this.capabilities = capabilities;
        this.feePlanCodes = feePlanCodes;
    }
    
    public OnboardingInviteError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> returnURL() {
        return returnURL;
    }

    @JsonIgnore
    public Optional<String> termsOfServiceURL() {
        return termsOfServiceURL;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> scopes() {
        return (Optional<Map<String, String>>) scopes;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> capabilities() {
        return (Optional<Map<String, String>>) capabilities;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> feePlanCodes() {
        return (Optional<Map<String, String>>) feePlanCodes;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public OnboardingInviteError withReturnURL(String returnURL) {
        Utils.checkNotNull(returnURL, "returnURL");
        this.returnURL = Optional.ofNullable(returnURL);
        return this;
    }

    public OnboardingInviteError withReturnURL(Optional<String> returnURL) {
        Utils.checkNotNull(returnURL, "returnURL");
        this.returnURL = returnURL;
        return this;
    }

    public OnboardingInviteError withTermsOfServiceURL(String termsOfServiceURL) {
        Utils.checkNotNull(termsOfServiceURL, "termsOfServiceURL");
        this.termsOfServiceURL = Optional.ofNullable(termsOfServiceURL);
        return this;
    }

    public OnboardingInviteError withTermsOfServiceURL(Optional<String> termsOfServiceURL) {
        Utils.checkNotNull(termsOfServiceURL, "termsOfServiceURL");
        this.termsOfServiceURL = termsOfServiceURL;
        return this;
    }

    public OnboardingInviteError withScopes(Map<String, String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = Optional.ofNullable(scopes);
        return this;
    }

    public OnboardingInviteError withScopes(Optional<? extends Map<String, String>> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public OnboardingInviteError withCapabilities(Map<String, String> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = Optional.ofNullable(capabilities);
        return this;
    }

    public OnboardingInviteError withCapabilities(Optional<? extends Map<String, String>> capabilities) {
        Utils.checkNotNull(capabilities, "capabilities");
        this.capabilities = capabilities;
        return this;
    }

    public OnboardingInviteError withFeePlanCodes(Map<String, String> feePlanCodes) {
        Utils.checkNotNull(feePlanCodes, "feePlanCodes");
        this.feePlanCodes = Optional.ofNullable(feePlanCodes);
        return this;
    }

    public OnboardingInviteError withFeePlanCodes(Optional<? extends Map<String, String>> feePlanCodes) {
        Utils.checkNotNull(feePlanCodes, "feePlanCodes");
        this.feePlanCodes = feePlanCodes;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OnboardingInviteError other = (OnboardingInviteError) o;
        return 
            Objects.deepEquals(this.returnURL, other.returnURL) &&
            Objects.deepEquals(this.termsOfServiceURL, other.termsOfServiceURL) &&
            Objects.deepEquals(this.scopes, other.scopes) &&
            Objects.deepEquals(this.capabilities, other.capabilities) &&
            Objects.deepEquals(this.feePlanCodes, other.feePlanCodes);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            returnURL,
            termsOfServiceURL,
            scopes,
            capabilities,
            feePlanCodes);
    }
    
    @Override
    public String toString() {
        return Utils.toString(OnboardingInviteError.class,
                "returnURL", returnURL,
                "termsOfServiceURL", termsOfServiceURL,
                "scopes", scopes,
                "capabilities", capabilities,
                "feePlanCodes", feePlanCodes);
    }
    
    public final static class Builder {
 
        private Optional<String> returnURL = Optional.empty();
 
        private Optional<String> termsOfServiceURL = Optional.empty();
 
        private Optional<? extends Map<String, String>> scopes = Optional.empty();
 
        private Optional<? extends Map<String, String>> capabilities = Optional.empty();
 
        private Optional<? extends Map<String, String>> feePlanCodes = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder returnURL(String returnURL) {
            Utils.checkNotNull(returnURL, "returnURL");
            this.returnURL = Optional.ofNullable(returnURL);
            return this;
        }

        public Builder returnURL(Optional<String> returnURL) {
            Utils.checkNotNull(returnURL, "returnURL");
            this.returnURL = returnURL;
            return this;
        }

        public Builder termsOfServiceURL(String termsOfServiceURL) {
            Utils.checkNotNull(termsOfServiceURL, "termsOfServiceURL");
            this.termsOfServiceURL = Optional.ofNullable(termsOfServiceURL);
            return this;
        }

        public Builder termsOfServiceURL(Optional<String> termsOfServiceURL) {
            Utils.checkNotNull(termsOfServiceURL, "termsOfServiceURL");
            this.termsOfServiceURL = termsOfServiceURL;
            return this;
        }

        public Builder scopes(Map<String, String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        public Builder scopes(Optional<? extends Map<String, String>> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder capabilities(Map<String, String> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        public Builder capabilities(Optional<? extends Map<String, String>> capabilities) {
            Utils.checkNotNull(capabilities, "capabilities");
            this.capabilities = capabilities;
            return this;
        }

        public Builder feePlanCodes(Map<String, String> feePlanCodes) {
            Utils.checkNotNull(feePlanCodes, "feePlanCodes");
            this.feePlanCodes = Optional.ofNullable(feePlanCodes);
            return this;
        }

        public Builder feePlanCodes(Optional<? extends Map<String, String>> feePlanCodes) {
            Utils.checkNotNull(feePlanCodes, "feePlanCodes");
            this.feePlanCodes = feePlanCodes;
            return this;
        }
        
        public OnboardingInviteError build() {
            return new OnboardingInviteError(
                returnURL,
                termsOfServiceURL,
                scopes,
                capabilities,
                feePlanCodes);
        }
    }
}

