/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class MicroDepositValidationError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amounts")
    private Optional<String> amounts;

    @JsonCreator
    public MicroDepositValidationError(
            @JsonProperty("amounts") Optional<String> amounts) {
        Utils.checkNotNull(amounts, "amounts");
        this.amounts = amounts;
    }
    
    public MicroDepositValidationError() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> amounts() {
        return amounts;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public MicroDepositValidationError withAmounts(String amounts) {
        Utils.checkNotNull(amounts, "amounts");
        this.amounts = Optional.ofNullable(amounts);
        return this;
    }

    public MicroDepositValidationError withAmounts(Optional<String> amounts) {
        Utils.checkNotNull(amounts, "amounts");
        this.amounts = amounts;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MicroDepositValidationError other = (MicroDepositValidationError) o;
        return 
            Objects.deepEquals(this.amounts, other.amounts);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            amounts);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MicroDepositValidationError.class,
                "amounts", amounts);
    }
    
    public final static class Builder {
 
        private Optional<String> amounts = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder amounts(String amounts) {
            Utils.checkNotNull(amounts, "amounts");
            this.amounts = Optional.ofNullable(amounts);
            return this;
        }

        public Builder amounts(Optional<String> amounts) {
            Utils.checkNotNull(amounts, "amounts");
            this.amounts = amounts;
            return this;
        }
        
        public MicroDepositValidationError build() {
            return new MicroDepositValidationError(
                amounts);
        }
    }
}

