/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.End2EndEncryptionError;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class LinkCardError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("e2ee")
    private Optional<? extends End2EndEncryptionError> e2ee;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardNumber")
    private Optional<String> cardNumber;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardCvv")
    private Optional<String> cardCvv;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiration")
    private Optional<String> expiration;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("holderName")
    private Optional<String> holderName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("billingAddress")
    private Optional<String> billingAddress;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardOnFile")
    private Optional<String> cardOnFile;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("merchantAccountID")
    private Optional<String> merchantAccountID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("verifyName")
    private Optional<String> verifyName;

    @JsonCreator
    public LinkCardError(
            @JsonProperty("error") Optional<String> error,
            @JsonProperty("e2ee") Optional<? extends End2EndEncryptionError> e2ee,
            @JsonProperty("cardNumber") Optional<String> cardNumber,
            @JsonProperty("cardCvv") Optional<String> cardCvv,
            @JsonProperty("expiration") Optional<String> expiration,
            @JsonProperty("holderName") Optional<String> holderName,
            @JsonProperty("billingAddress") Optional<String> billingAddress,
            @JsonProperty("cardOnFile") Optional<String> cardOnFile,
            @JsonProperty("merchantAccountID") Optional<String> merchantAccountID,
            @JsonProperty("verifyName") Optional<String> verifyName) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(e2ee, "e2ee");
        Utils.checkNotNull(cardNumber, "cardNumber");
        Utils.checkNotNull(cardCvv, "cardCvv");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(holderName, "holderName");
        Utils.checkNotNull(billingAddress, "billingAddress");
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(verifyName, "verifyName");
        this.error = error;
        this.e2ee = e2ee;
        this.cardNumber = cardNumber;
        this.cardCvv = cardCvv;
        this.expiration = expiration;
        this.holderName = holderName;
        this.billingAddress = billingAddress;
        this.cardOnFile = cardOnFile;
        this.merchantAccountID = merchantAccountID;
        this.verifyName = verifyName;
    }
    
    public LinkCardError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<End2EndEncryptionError> e2ee() {
        return (Optional<End2EndEncryptionError>) e2ee;
    }

    @JsonIgnore
    public Optional<String> cardNumber() {
        return cardNumber;
    }

    @JsonIgnore
    public Optional<String> cardCvv() {
        return cardCvv;
    }

    @JsonIgnore
    public Optional<String> expiration() {
        return expiration;
    }

    @JsonIgnore
    public Optional<String> holderName() {
        return holderName;
    }

    @JsonIgnore
    public Optional<String> billingAddress() {
        return billingAddress;
    }

    @JsonIgnore
    public Optional<String> cardOnFile() {
        return cardOnFile;
    }

    @JsonIgnore
    public Optional<String> merchantAccountID() {
        return merchantAccountID;
    }

    @JsonIgnore
    public Optional<String> verifyName() {
        return verifyName;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public LinkCardError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }

    public LinkCardError withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public LinkCardError withE2ee(End2EndEncryptionError e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = Optional.ofNullable(e2ee);
        return this;
    }

    public LinkCardError withE2ee(Optional<? extends End2EndEncryptionError> e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = e2ee;
        return this;
    }

    public LinkCardError withCardNumber(String cardNumber) {
        Utils.checkNotNull(cardNumber, "cardNumber");
        this.cardNumber = Optional.ofNullable(cardNumber);
        return this;
    }

    public LinkCardError withCardNumber(Optional<String> cardNumber) {
        Utils.checkNotNull(cardNumber, "cardNumber");
        this.cardNumber = cardNumber;
        return this;
    }

    public LinkCardError withCardCvv(String cardCvv) {
        Utils.checkNotNull(cardCvv, "cardCvv");
        this.cardCvv = Optional.ofNullable(cardCvv);
        return this;
    }

    public LinkCardError withCardCvv(Optional<String> cardCvv) {
        Utils.checkNotNull(cardCvv, "cardCvv");
        this.cardCvv = cardCvv;
        return this;
    }

    public LinkCardError withExpiration(String expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }

    public LinkCardError withExpiration(Optional<String> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public LinkCardError withHolderName(String holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = Optional.ofNullable(holderName);
        return this;
    }

    public LinkCardError withHolderName(Optional<String> holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = holderName;
        return this;
    }

    public LinkCardError withBillingAddress(String billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = Optional.ofNullable(billingAddress);
        return this;
    }

    public LinkCardError withBillingAddress(Optional<String> billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = billingAddress;
        return this;
    }

    public LinkCardError withCardOnFile(String cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = Optional.ofNullable(cardOnFile);
        return this;
    }

    public LinkCardError withCardOnFile(Optional<String> cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = cardOnFile;
        return this;
    }

    public LinkCardError withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = Optional.ofNullable(merchantAccountID);
        return this;
    }

    public LinkCardError withMerchantAccountID(Optional<String> merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    public LinkCardError withVerifyName(String verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = Optional.ofNullable(verifyName);
        return this;
    }

    public LinkCardError withVerifyName(Optional<String> verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = verifyName;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkCardError other = (LinkCardError) o;
        return 
            Objects.deepEquals(this.error, other.error) &&
            Objects.deepEquals(this.e2ee, other.e2ee) &&
            Objects.deepEquals(this.cardNumber, other.cardNumber) &&
            Objects.deepEquals(this.cardCvv, other.cardCvv) &&
            Objects.deepEquals(this.expiration, other.expiration) &&
            Objects.deepEquals(this.holderName, other.holderName) &&
            Objects.deepEquals(this.billingAddress, other.billingAddress) &&
            Objects.deepEquals(this.cardOnFile, other.cardOnFile) &&
            Objects.deepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Objects.deepEquals(this.verifyName, other.verifyName);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            error,
            e2ee,
            cardNumber,
            cardCvv,
            expiration,
            holderName,
            billingAddress,
            cardOnFile,
            merchantAccountID,
            verifyName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkCardError.class,
                "error", error,
                "e2ee", e2ee,
                "cardNumber", cardNumber,
                "cardCvv", cardCvv,
                "expiration", expiration,
                "holderName", holderName,
                "billingAddress", billingAddress,
                "cardOnFile", cardOnFile,
                "merchantAccountID", merchantAccountID,
                "verifyName", verifyName);
    }
    
    public final static class Builder {
 
        private Optional<String> error = Optional.empty();
 
        private Optional<? extends End2EndEncryptionError> e2ee = Optional.empty();
 
        private Optional<String> cardNumber = Optional.empty();
 
        private Optional<String> cardCvv = Optional.empty();
 
        private Optional<String> expiration = Optional.empty();
 
        private Optional<String> holderName = Optional.empty();
 
        private Optional<String> billingAddress = Optional.empty();
 
        private Optional<String> cardOnFile = Optional.empty();
 
        private Optional<String> merchantAccountID = Optional.empty();
 
        private Optional<String> verifyName = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder e2ee(End2EndEncryptionError e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = Optional.ofNullable(e2ee);
            return this;
        }

        public Builder e2ee(Optional<? extends End2EndEncryptionError> e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = e2ee;
            return this;
        }

        public Builder cardNumber(String cardNumber) {
            Utils.checkNotNull(cardNumber, "cardNumber");
            this.cardNumber = Optional.ofNullable(cardNumber);
            return this;
        }

        public Builder cardNumber(Optional<String> cardNumber) {
            Utils.checkNotNull(cardNumber, "cardNumber");
            this.cardNumber = cardNumber;
            return this;
        }

        public Builder cardCvv(String cardCvv) {
            Utils.checkNotNull(cardCvv, "cardCvv");
            this.cardCvv = Optional.ofNullable(cardCvv);
            return this;
        }

        public Builder cardCvv(Optional<String> cardCvv) {
            Utils.checkNotNull(cardCvv, "cardCvv");
            this.cardCvv = cardCvv;
            return this;
        }

        public Builder expiration(String expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        public Builder expiration(Optional<String> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }

        public Builder holderName(String holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = Optional.ofNullable(holderName);
            return this;
        }

        public Builder holderName(Optional<String> holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = holderName;
            return this;
        }

        public Builder billingAddress(String billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        public Builder billingAddress(Optional<String> billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder cardOnFile(String cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = Optional.ofNullable(cardOnFile);
            return this;
        }

        public Builder cardOnFile(Optional<String> cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = cardOnFile;
            return this;
        }

        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = Optional.ofNullable(merchantAccountID);
            return this;
        }

        public Builder merchantAccountID(Optional<String> merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }

        public Builder verifyName(String verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = Optional.ofNullable(verifyName);
            return this;
        }

        public Builder verifyName(Optional<String> verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = verifyName;
            return this;
        }
        
        public LinkCardError build() {
            return new LinkCardError(
                error,
                e2ee,
                cardNumber,
                cardCvv,
                expiration,
                holderName,
                billingAddress,
                cardOnFile,
                merchantAccountID,
                verifyName);
        }
    }
}

