/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class LinkApplePayError extends RuntimeException {

    /**
     * Describes an error that wasn't attributable to a single request field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("error")
    private Optional<String> error;

    /**
     * Describes an error within the `token.paymentData` request field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentData")
    private Optional<String> paymentData;

    /**
     * Describes an error within the `token.paymentMethod` request field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("paymentMethod")
    private Optional<String> paymentMethod;

    /**
     * Describes an error within the `token.transactionIdentifier` request field.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transactionIdentifier")
    private Optional<String> transactionIdentifier;

    @JsonCreator
    public LinkApplePayError(
            @JsonProperty("error") Optional<String> error,
            @JsonProperty("paymentData") Optional<String> paymentData,
            @JsonProperty("paymentMethod") Optional<String> paymentMethod,
            @JsonProperty("transactionIdentifier") Optional<String> transactionIdentifier) {
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(paymentData, "paymentData");
        Utils.checkNotNull(paymentMethod, "paymentMethod");
        Utils.checkNotNull(transactionIdentifier, "transactionIdentifier");
        this.error = error;
        this.paymentData = paymentData;
        this.paymentMethod = paymentMethod;
        this.transactionIdentifier = transactionIdentifier;
    }
    
    public LinkApplePayError() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Describes an error that wasn't attributable to a single request field.
     */
    @JsonIgnore
    public Optional<String> error() {
        return error;
    }

    /**
     * Describes an error within the `token.paymentData` request field.
     */
    @JsonIgnore
    public Optional<String> paymentData() {
        return paymentData;
    }

    /**
     * Describes an error within the `token.paymentMethod` request field.
     */
    @JsonIgnore
    public Optional<String> paymentMethod() {
        return paymentMethod;
    }

    /**
     * Describes an error within the `token.transactionIdentifier` request field.
     */
    @JsonIgnore
    public Optional<String> transactionIdentifier() {
        return transactionIdentifier;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Describes an error that wasn't attributable to a single request field.
     */
    public LinkApplePayError withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }

    /**
     * Describes an error that wasn't attributable to a single request field.
     */
    public LinkApplePayError withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    /**
     * Describes an error within the `token.paymentData` request field.
     */
    public LinkApplePayError withPaymentData(String paymentData) {
        Utils.checkNotNull(paymentData, "paymentData");
        this.paymentData = Optional.ofNullable(paymentData);
        return this;
    }

    /**
     * Describes an error within the `token.paymentData` request field.
     */
    public LinkApplePayError withPaymentData(Optional<String> paymentData) {
        Utils.checkNotNull(paymentData, "paymentData");
        this.paymentData = paymentData;
        return this;
    }

    /**
     * Describes an error within the `token.paymentMethod` request field.
     */
    public LinkApplePayError withPaymentMethod(String paymentMethod) {
        Utils.checkNotNull(paymentMethod, "paymentMethod");
        this.paymentMethod = Optional.ofNullable(paymentMethod);
        return this;
    }

    /**
     * Describes an error within the `token.paymentMethod` request field.
     */
    public LinkApplePayError withPaymentMethod(Optional<String> paymentMethod) {
        Utils.checkNotNull(paymentMethod, "paymentMethod");
        this.paymentMethod = paymentMethod;
        return this;
    }

    /**
     * Describes an error within the `token.transactionIdentifier` request field.
     */
    public LinkApplePayError withTransactionIdentifier(String transactionIdentifier) {
        Utils.checkNotNull(transactionIdentifier, "transactionIdentifier");
        this.transactionIdentifier = Optional.ofNullable(transactionIdentifier);
        return this;
    }

    /**
     * Describes an error within the `token.transactionIdentifier` request field.
     */
    public LinkApplePayError withTransactionIdentifier(Optional<String> transactionIdentifier) {
        Utils.checkNotNull(transactionIdentifier, "transactionIdentifier");
        this.transactionIdentifier = transactionIdentifier;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkApplePayError other = (LinkApplePayError) o;
        return 
            Objects.deepEquals(this.error, other.error) &&
            Objects.deepEquals(this.paymentData, other.paymentData) &&
            Objects.deepEquals(this.paymentMethod, other.paymentMethod) &&
            Objects.deepEquals(this.transactionIdentifier, other.transactionIdentifier);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            error,
            paymentData,
            paymentMethod,
            transactionIdentifier);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkApplePayError.class,
                "error", error,
                "paymentData", paymentData,
                "paymentMethod", paymentMethod,
                "transactionIdentifier", transactionIdentifier);
    }
    
    public final static class Builder {
 
        private Optional<String> error = Optional.empty();
 
        private Optional<String> paymentData = Optional.empty();
 
        private Optional<String> paymentMethod = Optional.empty();
 
        private Optional<String> transactionIdentifier = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Describes an error that wasn't attributable to a single request field.
         */
        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        /**
         * Describes an error that wasn't attributable to a single request field.
         */
        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        /**
         * Describes an error within the `token.paymentData` request field.
         */
        public Builder paymentData(String paymentData) {
            Utils.checkNotNull(paymentData, "paymentData");
            this.paymentData = Optional.ofNullable(paymentData);
            return this;
        }

        /**
         * Describes an error within the `token.paymentData` request field.
         */
        public Builder paymentData(Optional<String> paymentData) {
            Utils.checkNotNull(paymentData, "paymentData");
            this.paymentData = paymentData;
            return this;
        }

        /**
         * Describes an error within the `token.paymentMethod` request field.
         */
        public Builder paymentMethod(String paymentMethod) {
            Utils.checkNotNull(paymentMethod, "paymentMethod");
            this.paymentMethod = Optional.ofNullable(paymentMethod);
            return this;
        }

        /**
         * Describes an error within the `token.paymentMethod` request field.
         */
        public Builder paymentMethod(Optional<String> paymentMethod) {
            Utils.checkNotNull(paymentMethod, "paymentMethod");
            this.paymentMethod = paymentMethod;
            return this;
        }

        /**
         * Describes an error within the `token.transactionIdentifier` request field.
         */
        public Builder transactionIdentifier(String transactionIdentifier) {
            Utils.checkNotNull(transactionIdentifier, "transactionIdentifier");
            this.transactionIdentifier = Optional.ofNullable(transactionIdentifier);
            return this;
        }

        /**
         * Describes an error within the `token.transactionIdentifier` request field.
         */
        public Builder transactionIdentifier(Optional<String> transactionIdentifier) {
            Utils.checkNotNull(transactionIdentifier, "transactionIdentifier");
            this.transactionIdentifier = transactionIdentifier;
            return this;
        }
        
        public LinkApplePayError build() {
            return new LinkApplePayError(
                error,
                paymentData,
                paymentMethod,
                transactionIdentifier);
        }
    }
}

