/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.AddressError;
import io.moov.sdk.models.components.BirthDateValidationError;
import io.moov.sdk.models.components.GovernmentIDError;
import io.moov.sdk.models.components.IndividualNameError;
import io.moov.sdk.models.components.PhoneNumberError;
import io.moov.sdk.models.components.RepresentativeResponsibilitiesError;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class Error {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private Optional<? extends IndividualNameError> name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private Optional<? extends PhoneNumberError> phone;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("address")
    private Optional<? extends AddressError> address;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("birthDate")
    private Optional<? extends BirthDateValidationError> birthDate;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("governmentID")
    private Optional<? extends GovernmentIDError> governmentID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("responsibilities")
    private Optional<? extends RepresentativeResponsibilitiesError> responsibilities;

    @JsonCreator
    public Error(
            @JsonProperty("name") Optional<? extends IndividualNameError> name,
            @JsonProperty("phone") Optional<? extends PhoneNumberError> phone,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("address") Optional<? extends AddressError> address,
            @JsonProperty("birthDate") Optional<? extends BirthDateValidationError> birthDate,
            @JsonProperty("governmentID") Optional<? extends GovernmentIDError> governmentID,
            @JsonProperty("responsibilities") Optional<? extends RepresentativeResponsibilitiesError> responsibilities) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phone, "phone");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(birthDate, "birthDate");
        Utils.checkNotNull(governmentID, "governmentID");
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.birthDate = birthDate;
        this.governmentID = governmentID;
        this.responsibilities = responsibilities;
    }
    
    public Error() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IndividualNameError> name() {
        return (Optional<IndividualNameError>) name;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PhoneNumberError> phone() {
        return (Optional<PhoneNumberError>) phone;
    }

    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AddressError> address() {
        return (Optional<AddressError>) address;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BirthDateValidationError> birthDate() {
        return (Optional<BirthDateValidationError>) birthDate;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GovernmentIDError> governmentID() {
        return (Optional<GovernmentIDError>) governmentID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<RepresentativeResponsibilitiesError> responsibilities() {
        return (Optional<RepresentativeResponsibilitiesError>) responsibilities;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Error withName(IndividualNameError name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public Error withName(Optional<? extends IndividualNameError> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Error withPhone(PhoneNumberError phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = Optional.ofNullable(phone);
        return this;
    }

    public Error withPhone(Optional<? extends PhoneNumberError> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }

    public Error withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public Error withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public Error withAddress(AddressError address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public Error withAddress(Optional<? extends AddressError> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public Error withBirthDate(BirthDateValidationError birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = Optional.ofNullable(birthDate);
        return this;
    }

    public Error withBirthDate(Optional<? extends BirthDateValidationError> birthDate) {
        Utils.checkNotNull(birthDate, "birthDate");
        this.birthDate = birthDate;
        return this;
    }

    public Error withGovernmentID(GovernmentIDError governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = Optional.ofNullable(governmentID);
        return this;
    }

    public Error withGovernmentID(Optional<? extends GovernmentIDError> governmentID) {
        Utils.checkNotNull(governmentID, "governmentID");
        this.governmentID = governmentID;
        return this;
    }

    public Error withResponsibilities(RepresentativeResponsibilitiesError responsibilities) {
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.responsibilities = Optional.ofNullable(responsibilities);
        return this;
    }

    public Error withResponsibilities(Optional<? extends RepresentativeResponsibilitiesError> responsibilities) {
        Utils.checkNotNull(responsibilities, "responsibilities");
        this.responsibilities = responsibilities;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Error other = (Error) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.phone, other.phone) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.address, other.address) &&
            Objects.deepEquals(this.birthDate, other.birthDate) &&
            Objects.deepEquals(this.governmentID, other.governmentID) &&
            Objects.deepEquals(this.responsibilities, other.responsibilities);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            phone,
            email,
            address,
            birthDate,
            governmentID,
            responsibilities);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Error.class,
                "name", name,
                "phone", phone,
                "email", email,
                "address", address,
                "birthDate", birthDate,
                "governmentID", governmentID,
                "responsibilities", responsibilities);
    }
    
    public final static class Builder {
 
        private Optional<? extends IndividualNameError> name = Optional.empty();
 
        private Optional<? extends PhoneNumberError> phone = Optional.empty();
 
        private Optional<String> email = Optional.empty();
 
        private Optional<? extends AddressError> address = Optional.empty();
 
        private Optional<? extends BirthDateValidationError> birthDate = Optional.empty();
 
        private Optional<? extends GovernmentIDError> governmentID = Optional.empty();
 
        private Optional<? extends RepresentativeResponsibilitiesError> responsibilities = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder name(IndividualNameError name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<? extends IndividualNameError> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder phone(PhoneNumberError phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public Builder phone(Optional<? extends PhoneNumberError> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }

        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder address(AddressError address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends AddressError> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder birthDate(BirthDateValidationError birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = Optional.ofNullable(birthDate);
            return this;
        }

        public Builder birthDate(Optional<? extends BirthDateValidationError> birthDate) {
            Utils.checkNotNull(birthDate, "birthDate");
            this.birthDate = birthDate;
            return this;
        }

        public Builder governmentID(GovernmentIDError governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = Optional.ofNullable(governmentID);
            return this;
        }

        public Builder governmentID(Optional<? extends GovernmentIDError> governmentID) {
            Utils.checkNotNull(governmentID, "governmentID");
            this.governmentID = governmentID;
            return this;
        }

        public Builder responsibilities(RepresentativeResponsibilitiesError responsibilities) {
            Utils.checkNotNull(responsibilities, "responsibilities");
            this.responsibilities = Optional.ofNullable(responsibilities);
            return this;
        }

        public Builder responsibilities(Optional<? extends RepresentativeResponsibilitiesError> responsibilities) {
            Utils.checkNotNull(responsibilities, "responsibilities");
            this.responsibilities = responsibilities;
            return this;
        }
        
        public Error build() {
            return new Error(
                name,
                phone,
                email,
                address,
                birthDate,
                governmentID,
                responsibilities);
        }
    }
}
