/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("serial")
public class AuthTokenRequestError extends RuntimeException {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("scope")
    private Optional<String> scope;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("refresh_token")
    private Optional<String> refreshToken;

    @JsonCreator
    public AuthTokenRequestError(
            @JsonProperty("scope") Optional<String> scope,
            @JsonProperty("refresh_token") Optional<String> refreshToken) {
        Utils.checkNotNull(scope, "scope");
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.scope = scope;
        this.refreshToken = refreshToken;
    }
    
    public AuthTokenRequestError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> scope() {
        return scope;
    }

    @JsonIgnore
    public Optional<String> refreshToken() {
        return refreshToken;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public AuthTokenRequestError withScope(String scope) {
        Utils.checkNotNull(scope, "scope");
        this.scope = Optional.ofNullable(scope);
        return this;
    }

    public AuthTokenRequestError withScope(Optional<String> scope) {
        Utils.checkNotNull(scope, "scope");
        this.scope = scope;
        return this;
    }

    public AuthTokenRequestError withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = Optional.ofNullable(refreshToken);
        return this;
    }

    public AuthTokenRequestError withRefreshToken(Optional<String> refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthTokenRequestError other = (AuthTokenRequestError) o;
        return 
            Objects.deepEquals(this.scope, other.scope) &&
            Objects.deepEquals(this.refreshToken, other.refreshToken);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            scope,
            refreshToken);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AuthTokenRequestError.class,
                "scope", scope,
                "refreshToken", refreshToken);
    }
    
    public final static class Builder {
 
        private Optional<String> scope = Optional.empty();
 
        private Optional<String> refreshToken = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder scope(String scope) {
            Utils.checkNotNull(scope, "scope");
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        public Builder scope(Optional<String> scope) {
            Utils.checkNotNull(scope, "scope");
            this.scope = scope;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = Optional.ofNullable(refreshToken);
            return this;
        }

        public Builder refreshToken(Optional<String> refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }
        
        public AuthTokenRequestError build() {
            return new AuthTokenRequestError(
                scope,
                refreshToken);
        }
    }
}

