/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class WebhookDataTransferUpdated {

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonProperty("accountID")
    private String accountID;

    @JsonProperty("transferID")
    private String transferID;

    @JsonProperty("status")
    private WebhookDataTransferStatus status;

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonProperty("source")
    private WebhookTransferPaymentMethodDetails source;

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonProperty("destination")
    private WebhookTransferPaymentMethodDetails destination;

    @JsonCreator
    public WebhookDataTransferUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("status") WebhookDataTransferStatus status,
            @JsonProperty("source") WebhookTransferPaymentMethodDetails source,
            @JsonProperty("destination") WebhookTransferPaymentMethodDetails destination) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(destination, "destination");
        this.accountID = accountID;
        this.transferID = transferID;
        this.status = status;
        this.source = source;
        this.destination = destination;
    }

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public WebhookDataTransferStatus status() {
        return status;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonIgnore
    public WebhookTransferPaymentMethodDetails source() {
        return source;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    @JsonIgnore
    public WebhookTransferPaymentMethodDetails destination() {
        return destination;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The accountID which facilitated the transfer.
     */
    public WebhookDataTransferUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataTransferUpdated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataTransferUpdated withStatus(WebhookDataTransferStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    public WebhookDataTransferUpdated withSource(WebhookTransferPaymentMethodDetails source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    /**
     * Payment method details for the source or destination of a transfer.
     */
    public WebhookDataTransferUpdated withDestination(WebhookTransferPaymentMethodDetails destination) {
        Utils.checkNotNull(destination, "destination");
        this.destination = destination;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataTransferUpdated other = (WebhookDataTransferUpdated) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.source, other.source) &&
            Objects.deepEquals(this.destination, other.destination);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            transferID,
            status,
            source,
            destination);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataTransferUpdated.class,
                "accountID", accountID,
                "transferID", transferID,
                "status", status,
                "source", source,
                "destination", destination);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private String transferID;
 
        private WebhookDataTransferStatus status;
 
        private WebhookTransferPaymentMethodDetails source;
 
        private WebhookTransferPaymentMethodDetails destination;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The accountID which facilitated the transfer.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder status(WebhookDataTransferStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * Payment method details for the source or destination of a transfer.
         */
        public Builder source(WebhookTransferPaymentMethodDetails source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }

        /**
         * Payment method details for the source or destination of a transfer.
         */
        public Builder destination(WebhookTransferPaymentMethodDetails destination) {
            Utils.checkNotNull(destination, "destination");
            this.destination = destination;
            return this;
        }
        
        public WebhookDataTransferUpdated build() {
            return new WebhookDataTransferUpdated(
                accountID,
                transferID,
                status,
                source,
                destination);
        }
    }
}
