/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class WebhookDataTransferCreated {

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonProperty("accountID")
    private String accountID;

    @JsonProperty("transferID")
    private String transferID;

    @JsonProperty("status")
    private WebhookDataTransferStatus status;

    @JsonCreator
    public WebhookDataTransferCreated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("status") WebhookDataTransferStatus status) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(status, "status");
        this.accountID = accountID;
        this.transferID = transferID;
        this.status = status;
    }

    /**
     * The accountID which facilitated the transfer.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public WebhookDataTransferStatus status() {
        return status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The accountID which facilitated the transfer.
     */
    public WebhookDataTransferCreated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataTransferCreated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataTransferCreated withStatus(WebhookDataTransferStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataTransferCreated other = (WebhookDataTransferCreated) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            transferID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataTransferCreated.class,
                "accountID", accountID,
                "transferID", transferID,
                "status", status);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private String transferID;
 
        private WebhookDataTransferStatus status;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The accountID which facilitated the transfer.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder status(WebhookDataTransferStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public WebhookDataTransferCreated build() {
            return new WebhookDataTransferCreated(
                accountID,
                transferID,
                status);
        }
    }
}
