/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class WebhookDataTerminalApplicationCreated {

    @JsonProperty("terminalApplicationID")
    private String terminalApplicationID;

    /**
     * Status of the terminal application.
     */
    @JsonProperty("status")
    private TerminalApplicationStatus status;

    @JsonCreator
    public WebhookDataTerminalApplicationCreated(
            @JsonProperty("terminalApplicationID") String terminalApplicationID,
            @JsonProperty("status") TerminalApplicationStatus status) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        Utils.checkNotNull(status, "status");
        this.terminalApplicationID = terminalApplicationID;
        this.status = status;
    }

    @JsonIgnore
    public String terminalApplicationID() {
        return terminalApplicationID;
    }

    /**
     * Status of the terminal application.
     */
    @JsonIgnore
    public TerminalApplicationStatus status() {
        return status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataTerminalApplicationCreated withTerminalApplicationID(String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
        return this;
    }

    /**
     * Status of the terminal application.
     */
    public WebhookDataTerminalApplicationCreated withStatus(TerminalApplicationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataTerminalApplicationCreated other = (WebhookDataTerminalApplicationCreated) o;
        return 
            Objects.deepEquals(this.terminalApplicationID, other.terminalApplicationID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            terminalApplicationID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataTerminalApplicationCreated.class,
                "terminalApplicationID", terminalApplicationID,
                "status", status);
    }
    
    public final static class Builder {
 
        private String terminalApplicationID;
 
        private TerminalApplicationStatus status;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder terminalApplicationID(String terminalApplicationID) {
            Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
            this.terminalApplicationID = terminalApplicationID;
            return this;
        }

        /**
         * Status of the terminal application.
         */
        public Builder status(TerminalApplicationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public WebhookDataTerminalApplicationCreated build() {
            return new WebhookDataTerminalApplicationCreated(
                terminalApplicationID,
                status);
        }
    }
}
