/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public class WebhookDataSweepUpdated {

    @JsonProperty("walletID")
    private String walletID;

    @JsonProperty("sweepID")
    private String sweepID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transferID")
    private Optional<String> transferID;

    @JsonProperty("status")
    private SweepStatus status;

    @JsonCreator
    public WebhookDataSweepUpdated(
            @JsonProperty("walletID") String walletID,
            @JsonProperty("sweepID") String sweepID,
            @JsonProperty("transferID") Optional<String> transferID,
            @JsonProperty("status") SweepStatus status) {
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(sweepID, "sweepID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(status, "status");
        this.walletID = walletID;
        this.sweepID = sweepID;
        this.transferID = transferID;
        this.status = status;
    }
    
    public WebhookDataSweepUpdated(
            String walletID,
            String sweepID,
            SweepStatus status) {
        this(walletID, sweepID, Optional.empty(), status);
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public String sweepID() {
        return sweepID;
    }

    @JsonIgnore
    public Optional<String> transferID() {
        return transferID;
    }

    @JsonIgnore
    public SweepStatus status() {
        return status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataSweepUpdated withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public WebhookDataSweepUpdated withSweepID(String sweepID) {
        Utils.checkNotNull(sweepID, "sweepID");
        this.sweepID = sweepID;
        return this;
    }

    public WebhookDataSweepUpdated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = Optional.ofNullable(transferID);
        return this;
    }

    public WebhookDataSweepUpdated withTransferID(Optional<String> transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataSweepUpdated withStatus(SweepStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataSweepUpdated other = (WebhookDataSweepUpdated) o;
        return 
            Objects.deepEquals(this.walletID, other.walletID) &&
            Objects.deepEquals(this.sweepID, other.sweepID) &&
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            walletID,
            sweepID,
            transferID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataSweepUpdated.class,
                "walletID", walletID,
                "sweepID", sweepID,
                "transferID", transferID,
                "status", status);
    }
    
    public final static class Builder {
 
        private String walletID;
 
        private String sweepID;
 
        private Optional<String> transferID = Optional.empty();
 
        private SweepStatus status;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }

        public Builder sweepID(String sweepID) {
            Utils.checkNotNull(sweepID, "sweepID");
            this.sweepID = sweepID;
            return this;
        }

        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = Optional.ofNullable(transferID);
            return this;
        }

        public Builder transferID(Optional<String> transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder status(SweepStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public WebhookDataSweepUpdated build() {
            return new WebhookDataSweepUpdated(
                walletID,
                sweepID,
                transferID,
                status);
        }
    }
}
