/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class WebhookDataRefundUpdated {

    @JsonProperty("accountID")
    private String accountID;

    @JsonProperty("transferID")
    private String transferID;

    @JsonProperty("refundID")
    private String refundID;

    @JsonProperty("status")
    private RefundStatus status;

    @JsonCreator
    public WebhookDataRefundUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("transferID") String transferID,
            @JsonProperty("refundID") String refundID,
            @JsonProperty("status") RefundStatus status) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(refundID, "refundID");
        Utils.checkNotNull(status, "status");
        this.accountID = accountID;
        this.transferID = transferID;
        this.refundID = refundID;
        this.status = status;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public String refundID() {
        return refundID;
    }

    @JsonIgnore
    public RefundStatus status() {
        return status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataRefundUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataRefundUpdated withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public WebhookDataRefundUpdated withRefundID(String refundID) {
        Utils.checkNotNull(refundID, "refundID");
        this.refundID = refundID;
        return this;
    }

    public WebhookDataRefundUpdated withStatus(RefundStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataRefundUpdated other = (WebhookDataRefundUpdated) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.transferID, other.transferID) &&
            Objects.deepEquals(this.refundID, other.refundID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            transferID,
            refundID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataRefundUpdated.class,
                "accountID", accountID,
                "transferID", transferID,
                "refundID", refundID,
                "status", status);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private String transferID;
 
        private String refundID;
 
        private RefundStatus status;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public Builder refundID(String refundID) {
            Utils.checkNotNull(refundID, "refundID");
            this.refundID = refundID;
            return this;
        }

        public Builder status(RefundStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public WebhookDataRefundUpdated build() {
            return new WebhookDataRefundUpdated(
                accountID,
                transferID,
                refundID,
                status);
        }
    }
}
