/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

public class WebhookDataNetworkIDUpdated {

    @JsonProperty("accountID")
    private String accountID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("visaMid")
    private Optional<String> visaMid;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mastercardMid")
    private Optional<String> mastercardMid;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("discoverMid")
    private Optional<String> discoverMid;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amexMid")
    private Optional<String> amexMid;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updatedOn")
    private Optional<OffsetDateTime> updatedOn;

    @JsonCreator
    public WebhookDataNetworkIDUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("visaMid") Optional<String> visaMid,
            @JsonProperty("mastercardMid") Optional<String> mastercardMid,
            @JsonProperty("discoverMid") Optional<String> discoverMid,
            @JsonProperty("amexMid") Optional<String> amexMid,
            @JsonProperty("updatedOn") Optional<OffsetDateTime> updatedOn) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(visaMid, "visaMid");
        Utils.checkNotNull(mastercardMid, "mastercardMid");
        Utils.checkNotNull(discoverMid, "discoverMid");
        Utils.checkNotNull(amexMid, "amexMid");
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.accountID = accountID;
        this.visaMid = visaMid;
        this.mastercardMid = mastercardMid;
        this.discoverMid = discoverMid;
        this.amexMid = amexMid;
        this.updatedOn = updatedOn;
    }
    
    public WebhookDataNetworkIDUpdated(
            String accountID) {
        this(accountID, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> visaMid() {
        return visaMid;
    }

    @JsonIgnore
    public Optional<String> mastercardMid() {
        return mastercardMid;
    }

    @JsonIgnore
    public Optional<String> discoverMid() {
        return discoverMid;
    }

    @JsonIgnore
    public Optional<String> amexMid() {
        return amexMid;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> updatedOn() {
        return updatedOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataNetworkIDUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataNetworkIDUpdated withVisaMid(String visaMid) {
        Utils.checkNotNull(visaMid, "visaMid");
        this.visaMid = Optional.ofNullable(visaMid);
        return this;
    }

    public WebhookDataNetworkIDUpdated withVisaMid(Optional<String> visaMid) {
        Utils.checkNotNull(visaMid, "visaMid");
        this.visaMid = visaMid;
        return this;
    }

    public WebhookDataNetworkIDUpdated withMastercardMid(String mastercardMid) {
        Utils.checkNotNull(mastercardMid, "mastercardMid");
        this.mastercardMid = Optional.ofNullable(mastercardMid);
        return this;
    }

    public WebhookDataNetworkIDUpdated withMastercardMid(Optional<String> mastercardMid) {
        Utils.checkNotNull(mastercardMid, "mastercardMid");
        this.mastercardMid = mastercardMid;
        return this;
    }

    public WebhookDataNetworkIDUpdated withDiscoverMid(String discoverMid) {
        Utils.checkNotNull(discoverMid, "discoverMid");
        this.discoverMid = Optional.ofNullable(discoverMid);
        return this;
    }

    public WebhookDataNetworkIDUpdated withDiscoverMid(Optional<String> discoverMid) {
        Utils.checkNotNull(discoverMid, "discoverMid");
        this.discoverMid = discoverMid;
        return this;
    }

    public WebhookDataNetworkIDUpdated withAmexMid(String amexMid) {
        Utils.checkNotNull(amexMid, "amexMid");
        this.amexMid = Optional.ofNullable(amexMid);
        return this;
    }

    public WebhookDataNetworkIDUpdated withAmexMid(Optional<String> amexMid) {
        Utils.checkNotNull(amexMid, "amexMid");
        this.amexMid = amexMid;
        return this;
    }

    public WebhookDataNetworkIDUpdated withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = Optional.ofNullable(updatedOn);
        return this;
    }

    public WebhookDataNetworkIDUpdated withUpdatedOn(Optional<OffsetDateTime> updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataNetworkIDUpdated other = (WebhookDataNetworkIDUpdated) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.visaMid, other.visaMid) &&
            Objects.deepEquals(this.mastercardMid, other.mastercardMid) &&
            Objects.deepEquals(this.discoverMid, other.discoverMid) &&
            Objects.deepEquals(this.amexMid, other.amexMid) &&
            Objects.deepEquals(this.updatedOn, other.updatedOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            visaMid,
            mastercardMid,
            discoverMid,
            amexMid,
            updatedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataNetworkIDUpdated.class,
                "accountID", accountID,
                "visaMid", visaMid,
                "mastercardMid", mastercardMid,
                "discoverMid", discoverMid,
                "amexMid", amexMid,
                "updatedOn", updatedOn);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private Optional<String> visaMid = Optional.empty();
 
        private Optional<String> mastercardMid = Optional.empty();
 
        private Optional<String> discoverMid = Optional.empty();
 
        private Optional<String> amexMid = Optional.empty();
 
        private Optional<OffsetDateTime> updatedOn = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder visaMid(String visaMid) {
            Utils.checkNotNull(visaMid, "visaMid");
            this.visaMid = Optional.ofNullable(visaMid);
            return this;
        }

        public Builder visaMid(Optional<String> visaMid) {
            Utils.checkNotNull(visaMid, "visaMid");
            this.visaMid = visaMid;
            return this;
        }

        public Builder mastercardMid(String mastercardMid) {
            Utils.checkNotNull(mastercardMid, "mastercardMid");
            this.mastercardMid = Optional.ofNullable(mastercardMid);
            return this;
        }

        public Builder mastercardMid(Optional<String> mastercardMid) {
            Utils.checkNotNull(mastercardMid, "mastercardMid");
            this.mastercardMid = mastercardMid;
            return this;
        }

        public Builder discoverMid(String discoverMid) {
            Utils.checkNotNull(discoverMid, "discoverMid");
            this.discoverMid = Optional.ofNullable(discoverMid);
            return this;
        }

        public Builder discoverMid(Optional<String> discoverMid) {
            Utils.checkNotNull(discoverMid, "discoverMid");
            this.discoverMid = discoverMid;
            return this;
        }

        public Builder amexMid(String amexMid) {
            Utils.checkNotNull(amexMid, "amexMid");
            this.amexMid = Optional.ofNullable(amexMid);
            return this;
        }

        public Builder amexMid(Optional<String> amexMid) {
            Utils.checkNotNull(amexMid, "amexMid");
            this.amexMid = amexMid;
            return this;
        }

        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = Optional.ofNullable(updatedOn);
            return this;
        }

        public Builder updatedOn(Optional<OffsetDateTime> updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }
        
        public WebhookDataNetworkIDUpdated build() {
            return new WebhookDataNetworkIDUpdated(
                accountID,
                visaMid,
                mastercardMid,
                discoverMid,
                amexMid,
                updatedOn);
        }
    }
}
