/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public class WebhookDataCapabilityUpdated {

    @JsonProperty("accountID")
    private String accountID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    @JsonProperty("capabilityID")
    private CapabilityID capabilityID;

    /**
     * The status of the capability requested for an account.
     */
    @JsonProperty("status")
    private CapabilityStatus status;

    @JsonCreator
    public WebhookDataCapabilityUpdated(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("foreignID") Optional<String> foreignID,
            @JsonProperty("capabilityID") CapabilityID capabilityID,
            @JsonProperty("status") CapabilityStatus status) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(foreignID, "foreignID");
        Utils.checkNotNull(capabilityID, "capabilityID");
        Utils.checkNotNull(status, "status");
        this.accountID = accountID;
        this.foreignID = foreignID;
        this.capabilityID = capabilityID;
        this.status = status;
    }
    
    public WebhookDataCapabilityUpdated(
            String accountID,
            CapabilityID capabilityID,
            CapabilityStatus status) {
        this(accountID, Optional.empty(), capabilityID, status);
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    @JsonIgnore
    public CapabilityID capabilityID() {
        return capabilityID;
    }

    /**
     * The status of the capability requested for an account.
     */
    @JsonIgnore
    public CapabilityStatus status() {
        return status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataCapabilityUpdated withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataCapabilityUpdated withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }

    public WebhookDataCapabilityUpdated withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    /**
     * Moov account capabilities.
     * 
     * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
     */
    public WebhookDataCapabilityUpdated withCapabilityID(CapabilityID capabilityID) {
        Utils.checkNotNull(capabilityID, "capabilityID");
        this.capabilityID = capabilityID;
        return this;
    }

    /**
     * The status of the capability requested for an account.
     */
    public WebhookDataCapabilityUpdated withStatus(CapabilityStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataCapabilityUpdated other = (WebhookDataCapabilityUpdated) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.foreignID, other.foreignID) &&
            Objects.deepEquals(this.capabilityID, other.capabilityID) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            foreignID,
            capabilityID,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataCapabilityUpdated.class,
                "accountID", accountID,
                "foreignID", foreignID,
                "capabilityID", capabilityID,
                "status", status);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private Optional<String> foreignID = Optional.empty();
 
        private CapabilityID capabilityID;
 
        private CapabilityStatus status;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }

        /**
         * Moov account capabilities.
         * 
         * <p>The `production-app` capability might appear in your list. This is a read-only capability that Moov requests and uses for account verification purposes. The capability remains active with your account and requires no additional action.
         */
        public Builder capabilityID(CapabilityID capabilityID) {
            Utils.checkNotNull(capabilityID, "capabilityID");
            this.capabilityID = capabilityID;
            return this;
        }

        /**
         * The status of the capability requested for an account.
         */
        public Builder status(CapabilityStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public WebhookDataCapabilityUpdated build() {
            return new WebhookDataCapabilityUpdated(
                accountID,
                foreignID,
                capabilityID,
                status);
        }
    }
}
