/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

public class WebhookDataAccountDeleted {

    @JsonProperty("accountID")
    private String accountID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("foreignID")
    private Optional<String> foreignID;

    @JsonCreator
    public WebhookDataAccountDeleted(
            @JsonProperty("accountID") String accountID,
            @JsonProperty("foreignID") Optional<String> foreignID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(foreignID, "foreignID");
        this.accountID = accountID;
        this.foreignID = foreignID;
    }
    
    public WebhookDataAccountDeleted(
            String accountID) {
        this(accountID, Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<String> foreignID() {
        return foreignID;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public WebhookDataAccountDeleted withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public WebhookDataAccountDeleted withForeignID(String foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = Optional.ofNullable(foreignID);
        return this;
    }

    public WebhookDataAccountDeleted withForeignID(Optional<String> foreignID) {
        Utils.checkNotNull(foreignID, "foreignID");
        this.foreignID = foreignID;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebhookDataAccountDeleted other = (WebhookDataAccountDeleted) o;
        return 
            Objects.deepEquals(this.accountID, other.accountID) &&
            Objects.deepEquals(this.foreignID, other.foreignID);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            accountID,
            foreignID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WebhookDataAccountDeleted.class,
                "accountID", accountID,
                "foreignID", foreignID);
    }
    
    public final static class Builder {
 
        private String accountID;
 
        private Optional<String> foreignID = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public Builder foreignID(String foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = Optional.ofNullable(foreignID);
            return this;
        }

        public Builder foreignID(Optional<String> foreignID) {
            Utils.checkNotNull(foreignID, "foreignID");
            this.foreignID = foreignID;
            return this;
        }
        
        public WebhookDataAccountDeleted build() {
            return new WebhookDataAccountDeleted(
                accountID,
                foreignID);
        }
    }
}
