/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * Wallet
 * 
 * <p>A Moov wallet to store funds for transfers.
 */
public class Wallet {

    @JsonProperty("walletID")
    private String walletID;

    @JsonProperty("availableBalance")
    private WalletAvailableBalance availableBalance;

    @JsonCreator
    public Wallet(
            @JsonProperty("walletID") String walletID,
            @JsonProperty("availableBalance") WalletAvailableBalance availableBalance) {
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(availableBalance, "availableBalance");
        this.walletID = walletID;
        this.availableBalance = availableBalance;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public WalletAvailableBalance availableBalance() {
        return availableBalance;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Wallet withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public Wallet withAvailableBalance(WalletAvailableBalance availableBalance) {
        Utils.checkNotNull(availableBalance, "availableBalance");
        this.availableBalance = availableBalance;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Wallet other = (Wallet) o;
        return 
            Objects.deepEquals(this.walletID, other.walletID) &&
            Objects.deepEquals(this.availableBalance, other.availableBalance);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            walletID,
            availableBalance);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Wallet.class,
                "walletID", walletID,
                "availableBalance", availableBalance);
    }
    
    public final static class Builder {
 
        private String walletID;
 
        private WalletAvailableBalance availableBalance;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }

        public Builder availableBalance(WalletAvailableBalance availableBalance) {
            Utils.checkNotNull(availableBalance, "availableBalance");
            this.availableBalance = availableBalance;
            return this;
        }
        
        public Wallet build() {
            return new Wallet(
                walletID,
                availableBalance);
        }
    }
}
