/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class UpdateCard {

    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("e2ee")
    private Optional<? extends E2EETokenUpdate> e2ee;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("billingAddress")
    private Optional<? extends UpdateCardAddress> billingAddress;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expiration")
    private Optional<? extends UpdateCardExpiration> expiration;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardCvv")
    private Optional<String> cardCvv;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardOnFile")
    private Optional<Boolean> cardOnFile;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("merchantAccountID")
    private Optional<String> merchantAccountID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("verifyName")
    private Optional<Boolean> verifyName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("holderName")
    private Optional<String> holderName;

    @JsonCreator
    public UpdateCard(
            @JsonProperty("e2ee") Optional<? extends E2EETokenUpdate> e2ee,
            @JsonProperty("billingAddress") Optional<? extends UpdateCardAddress> billingAddress,
            @JsonProperty("expiration") Optional<? extends UpdateCardExpiration> expiration,
            @JsonProperty("cardCvv") Optional<String> cardCvv,
            @JsonProperty("cardOnFile") Optional<Boolean> cardOnFile,
            @JsonProperty("merchantAccountID") Optional<String> merchantAccountID,
            @JsonProperty("verifyName") Optional<Boolean> verifyName,
            @JsonProperty("holderName") Optional<String> holderName) {
        Utils.checkNotNull(e2ee, "e2ee");
        Utils.checkNotNull(billingAddress, "billingAddress");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(cardCvv, "cardCvv");
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        Utils.checkNotNull(verifyName, "verifyName");
        Utils.checkNotNull(holderName, "holderName");
        this.e2ee = e2ee;
        this.billingAddress = billingAddress;
        this.expiration = expiration;
        this.cardCvv = cardCvv;
        this.cardOnFile = cardOnFile;
        this.merchantAccountID = merchantAccountID;
        this.verifyName = verifyName;
        this.holderName = holderName;
    }
    
    public UpdateCard() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<E2EETokenUpdate> e2ee() {
        return (Optional<E2EETokenUpdate>) e2ee;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<UpdateCardAddress> billingAddress() {
        return (Optional<UpdateCardAddress>) billingAddress;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<UpdateCardExpiration> expiration() {
        return (Optional<UpdateCardExpiration>) expiration;
    }

    @JsonIgnore
    public Optional<String> cardCvv() {
        return cardCvv;
    }

    @JsonIgnore
    public Optional<Boolean> cardOnFile() {
        return cardOnFile;
    }

    @JsonIgnore
    public Optional<String> merchantAccountID() {
        return merchantAccountID;
    }

    @JsonIgnore
    public Optional<Boolean> verifyName() {
        return verifyName;
    }

    @JsonIgnore
    public Optional<String> holderName() {
        return holderName;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    public UpdateCard withE2ee(E2EETokenUpdate e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = Optional.ofNullable(e2ee);
        return this;
    }

    /**
     * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
     * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
     * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
     */
    public UpdateCard withE2ee(Optional<? extends E2EETokenUpdate> e2ee) {
        Utils.checkNotNull(e2ee, "e2ee");
        this.e2ee = e2ee;
        return this;
    }

    public UpdateCard withBillingAddress(UpdateCardAddress billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = Optional.ofNullable(billingAddress);
        return this;
    }

    public UpdateCard withBillingAddress(Optional<? extends UpdateCardAddress> billingAddress) {
        Utils.checkNotNull(billingAddress, "billingAddress");
        this.billingAddress = billingAddress;
        return this;
    }

    public UpdateCard withExpiration(UpdateCardExpiration expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }

    public UpdateCard withExpiration(Optional<? extends UpdateCardExpiration> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public UpdateCard withCardCvv(String cardCvv) {
        Utils.checkNotNull(cardCvv, "cardCvv");
        this.cardCvv = Optional.ofNullable(cardCvv);
        return this;
    }

    public UpdateCard withCardCvv(Optional<String> cardCvv) {
        Utils.checkNotNull(cardCvv, "cardCvv");
        this.cardCvv = cardCvv;
        return this;
    }

    public UpdateCard withCardOnFile(boolean cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = Optional.ofNullable(cardOnFile);
        return this;
    }

    public UpdateCard withCardOnFile(Optional<Boolean> cardOnFile) {
        Utils.checkNotNull(cardOnFile, "cardOnFile");
        this.cardOnFile = cardOnFile;
        return this;
    }

    public UpdateCard withMerchantAccountID(String merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = Optional.ofNullable(merchantAccountID);
        return this;
    }

    public UpdateCard withMerchantAccountID(Optional<String> merchantAccountID) {
        Utils.checkNotNull(merchantAccountID, "merchantAccountID");
        this.merchantAccountID = merchantAccountID;
        return this;
    }

    public UpdateCard withVerifyName(boolean verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = Optional.ofNullable(verifyName);
        return this;
    }

    public UpdateCard withVerifyName(Optional<Boolean> verifyName) {
        Utils.checkNotNull(verifyName, "verifyName");
        this.verifyName = verifyName;
        return this;
    }

    public UpdateCard withHolderName(String holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = Optional.ofNullable(holderName);
        return this;
    }

    public UpdateCard withHolderName(Optional<String> holderName) {
        Utils.checkNotNull(holderName, "holderName");
        this.holderName = holderName;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateCard other = (UpdateCard) o;
        return 
            Objects.deepEquals(this.e2ee, other.e2ee) &&
            Objects.deepEquals(this.billingAddress, other.billingAddress) &&
            Objects.deepEquals(this.expiration, other.expiration) &&
            Objects.deepEquals(this.cardCvv, other.cardCvv) &&
            Objects.deepEquals(this.cardOnFile, other.cardOnFile) &&
            Objects.deepEquals(this.merchantAccountID, other.merchantAccountID) &&
            Objects.deepEquals(this.verifyName, other.verifyName) &&
            Objects.deepEquals(this.holderName, other.holderName);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            e2ee,
            billingAddress,
            expiration,
            cardCvv,
            cardOnFile,
            merchantAccountID,
            verifyName,
            holderName);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateCard.class,
                "e2ee", e2ee,
                "billingAddress", billingAddress,
                "expiration", expiration,
                "cardCvv", cardCvv,
                "cardOnFile", cardOnFile,
                "merchantAccountID", merchantAccountID,
                "verifyName", verifyName,
                "holderName", holderName);
    }
    
    public final static class Builder {
 
        private Optional<? extends E2EETokenUpdate> e2ee = Optional.empty();
 
        private Optional<? extends UpdateCardAddress> billingAddress = Optional.empty();
 
        private Optional<? extends UpdateCardExpiration> expiration = Optional.empty();
 
        private Optional<String> cardCvv = Optional.empty();
 
        private Optional<Boolean> cardOnFile = Optional.empty();
 
        private Optional<String> merchantAccountID = Optional.empty();
 
        private Optional<Boolean> verifyName = Optional.empty();
 
        private Optional<String> holderName = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
         * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
         * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
         */
        public Builder e2ee(E2EETokenUpdate e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = Optional.ofNullable(e2ee);
            return this;
        }

        /**
         * Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries. 
         * This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our 
         * [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
         */
        public Builder e2ee(Optional<? extends E2EETokenUpdate> e2ee) {
            Utils.checkNotNull(e2ee, "e2ee");
            this.e2ee = e2ee;
            return this;
        }

        public Builder billingAddress(UpdateCardAddress billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        public Builder billingAddress(Optional<? extends UpdateCardAddress> billingAddress) {
            Utils.checkNotNull(billingAddress, "billingAddress");
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder expiration(UpdateCardExpiration expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        public Builder expiration(Optional<? extends UpdateCardExpiration> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }

        public Builder cardCvv(String cardCvv) {
            Utils.checkNotNull(cardCvv, "cardCvv");
            this.cardCvv = Optional.ofNullable(cardCvv);
            return this;
        }

        public Builder cardCvv(Optional<String> cardCvv) {
            Utils.checkNotNull(cardCvv, "cardCvv");
            this.cardCvv = cardCvv;
            return this;
        }

        public Builder cardOnFile(boolean cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = Optional.ofNullable(cardOnFile);
            return this;
        }

        public Builder cardOnFile(Optional<Boolean> cardOnFile) {
            Utils.checkNotNull(cardOnFile, "cardOnFile");
            this.cardOnFile = cardOnFile;
            return this;
        }

        public Builder merchantAccountID(String merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = Optional.ofNullable(merchantAccountID);
            return this;
        }

        public Builder merchantAccountID(Optional<String> merchantAccountID) {
            Utils.checkNotNull(merchantAccountID, "merchantAccountID");
            this.merchantAccountID = merchantAccountID;
            return this;
        }

        public Builder verifyName(boolean verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = Optional.ofNullable(verifyName);
            return this;
        }

        public Builder verifyName(Optional<Boolean> verifyName) {
            Utils.checkNotNull(verifyName, "verifyName");
            this.verifyName = verifyName;
            return this;
        }

        public Builder holderName(String holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = Optional.ofNullable(holderName);
            return this;
        }

        public Builder holderName(Optional<String> holderName) {
            Utils.checkNotNull(holderName, "holderName");
            this.holderName = holderName;
            return this;
        }
        
        public UpdateCard build() {
            return new UpdateCard(
                e2ee,
                billingAddress,
                expiration,
                cardCvv,
                cardOnFile,
                merchantAccountID,
                verifyName,
                holderName);
        }
    }
}
