/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * Underwriting
 * 
 * <p>Describes underwriting values (in USD) used for card payment acceptance.
 */
public class Underwriting {

    @JsonProperty("averageTransactionSize")
    private long averageTransactionSize;

    @JsonProperty("maxTransactionSize")
    private long maxTransactionSize;

    @JsonProperty("averageMonthlyTransactionVolume")
    private long averageMonthlyTransactionVolume;

    /**
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonProperty("status")
    @Deprecated
    private UnderwritingStatus status;

    @JsonProperty("volumeByCustomerType")
    private VolumeByCustomerType volumeByCustomerType;

    @JsonProperty("cardVolumeDistribution")
    private CardVolumeDistribution cardVolumeDistribution;

    @JsonProperty("fulfillment")
    private FulfillmentDetails fulfillment;

    @JsonCreator
    public Underwriting(
            @JsonProperty("averageTransactionSize") long averageTransactionSize,
            @JsonProperty("maxTransactionSize") long maxTransactionSize,
            @JsonProperty("averageMonthlyTransactionVolume") long averageMonthlyTransactionVolume,
            @JsonProperty("status") UnderwritingStatus status,
            @JsonProperty("volumeByCustomerType") VolumeByCustomerType volumeByCustomerType,
            @JsonProperty("cardVolumeDistribution") CardVolumeDistribution cardVolumeDistribution,
            @JsonProperty("fulfillment") FulfillmentDetails fulfillment) {
        Utils.checkNotNull(averageTransactionSize, "averageTransactionSize");
        Utils.checkNotNull(maxTransactionSize, "maxTransactionSize");
        Utils.checkNotNull(averageMonthlyTransactionVolume, "averageMonthlyTransactionVolume");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(volumeByCustomerType, "volumeByCustomerType");
        Utils.checkNotNull(cardVolumeDistribution, "cardVolumeDistribution");
        Utils.checkNotNull(fulfillment, "fulfillment");
        this.averageTransactionSize = averageTransactionSize;
        this.maxTransactionSize = maxTransactionSize;
        this.averageMonthlyTransactionVolume = averageMonthlyTransactionVolume;
        this.status = status;
        this.volumeByCustomerType = volumeByCustomerType;
        this.cardVolumeDistribution = cardVolumeDistribution;
        this.fulfillment = fulfillment;
    }

    @JsonIgnore
    public long averageTransactionSize() {
        return averageTransactionSize;
    }

    @JsonIgnore
    public long maxTransactionSize() {
        return maxTransactionSize;
    }

    @JsonIgnore
    public long averageMonthlyTransactionVolume() {
        return averageMonthlyTransactionVolume;
    }

    /**
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public UnderwritingStatus status() {
        return status;
    }

    @JsonIgnore
    public VolumeByCustomerType volumeByCustomerType() {
        return volumeByCustomerType;
    }

    @JsonIgnore
    public CardVolumeDistribution cardVolumeDistribution() {
        return cardVolumeDistribution;
    }

    @JsonIgnore
    public FulfillmentDetails fulfillment() {
        return fulfillment;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public Underwriting withAverageTransactionSize(long averageTransactionSize) {
        Utils.checkNotNull(averageTransactionSize, "averageTransactionSize");
        this.averageTransactionSize = averageTransactionSize;
        return this;
    }

    public Underwriting withMaxTransactionSize(long maxTransactionSize) {
        Utils.checkNotNull(maxTransactionSize, "maxTransactionSize");
        this.maxTransactionSize = maxTransactionSize;
        return this;
    }

    public Underwriting withAverageMonthlyTransactionVolume(long averageMonthlyTransactionVolume) {
        Utils.checkNotNull(averageMonthlyTransactionVolume, "averageMonthlyTransactionVolume");
        this.averageMonthlyTransactionVolume = averageMonthlyTransactionVolume;
        return this;
    }

    /**
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Underwriting withStatus(UnderwritingStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Underwriting withVolumeByCustomerType(VolumeByCustomerType volumeByCustomerType) {
        Utils.checkNotNull(volumeByCustomerType, "volumeByCustomerType");
        this.volumeByCustomerType = volumeByCustomerType;
        return this;
    }

    public Underwriting withCardVolumeDistribution(CardVolumeDistribution cardVolumeDistribution) {
        Utils.checkNotNull(cardVolumeDistribution, "cardVolumeDistribution");
        this.cardVolumeDistribution = cardVolumeDistribution;
        return this;
    }

    public Underwriting withFulfillment(FulfillmentDetails fulfillment) {
        Utils.checkNotNull(fulfillment, "fulfillment");
        this.fulfillment = fulfillment;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Underwriting other = (Underwriting) o;
        return 
            Objects.deepEquals(this.averageTransactionSize, other.averageTransactionSize) &&
            Objects.deepEquals(this.maxTransactionSize, other.maxTransactionSize) &&
            Objects.deepEquals(this.averageMonthlyTransactionVolume, other.averageMonthlyTransactionVolume) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.volumeByCustomerType, other.volumeByCustomerType) &&
            Objects.deepEquals(this.cardVolumeDistribution, other.cardVolumeDistribution) &&
            Objects.deepEquals(this.fulfillment, other.fulfillment);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            averageTransactionSize,
            maxTransactionSize,
            averageMonthlyTransactionVolume,
            status,
            volumeByCustomerType,
            cardVolumeDistribution,
            fulfillment);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Underwriting.class,
                "averageTransactionSize", averageTransactionSize,
                "maxTransactionSize", maxTransactionSize,
                "averageMonthlyTransactionVolume", averageMonthlyTransactionVolume,
                "status", status,
                "volumeByCustomerType", volumeByCustomerType,
                "cardVolumeDistribution", cardVolumeDistribution,
                "fulfillment", fulfillment);
    }
    
    public final static class Builder {
 
        private Long averageTransactionSize;
 
        private Long maxTransactionSize;
 
        private Long averageMonthlyTransactionVolume;
 
        @Deprecated
        private UnderwritingStatus status;
 
        private VolumeByCustomerType volumeByCustomerType;
 
        private CardVolumeDistribution cardVolumeDistribution;
 
        private FulfillmentDetails fulfillment;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder averageTransactionSize(long averageTransactionSize) {
            Utils.checkNotNull(averageTransactionSize, "averageTransactionSize");
            this.averageTransactionSize = averageTransactionSize;
            return this;
        }

        public Builder maxTransactionSize(long maxTransactionSize) {
            Utils.checkNotNull(maxTransactionSize, "maxTransactionSize");
            this.maxTransactionSize = maxTransactionSize;
            return this;
        }

        public Builder averageMonthlyTransactionVolume(long averageMonthlyTransactionVolume) {
            Utils.checkNotNull(averageMonthlyTransactionVolume, "averageMonthlyTransactionVolume");
            this.averageMonthlyTransactionVolume = averageMonthlyTransactionVolume;
            return this;
        }

        /**
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder status(UnderwritingStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder volumeByCustomerType(VolumeByCustomerType volumeByCustomerType) {
            Utils.checkNotNull(volumeByCustomerType, "volumeByCustomerType");
            this.volumeByCustomerType = volumeByCustomerType;
            return this;
        }

        public Builder cardVolumeDistribution(CardVolumeDistribution cardVolumeDistribution) {
            Utils.checkNotNull(cardVolumeDistribution, "cardVolumeDistribution");
            this.cardVolumeDistribution = cardVolumeDistribution;
            return this;
        }

        public Builder fulfillment(FulfillmentDetails fulfillment) {
            Utils.checkNotNull(fulfillment, "fulfillment");
            this.fulfillment = fulfillment;
            return this;
        }
        
        public Underwriting build() {
            return new Underwriting(
                averageTransactionSize,
                maxTransactionSize,
                averageMonthlyTransactionVolume,
                status,
                volumeByCustomerType,
                cardVolumeDistribution,
                fulfillment);
        }
    }
}
