/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransferOptions {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sourceOptions")
    private Optional<? extends List<PaymentMethod>> sourceOptions;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("destinationOptions")
    private Optional<? extends List<PaymentMethod>> destinationOptions;

    @JsonCreator
    public TransferOptions(
            @JsonProperty("sourceOptions") Optional<? extends List<PaymentMethod>> sourceOptions,
            @JsonProperty("destinationOptions") Optional<? extends List<PaymentMethod>> destinationOptions) {
        Utils.checkNotNull(sourceOptions, "sourceOptions");
        Utils.checkNotNull(destinationOptions, "destinationOptions");
        this.sourceOptions = sourceOptions;
        this.destinationOptions = destinationOptions;
    }
    
    public TransferOptions() {
        this(Optional.empty(), Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<PaymentMethod>> sourceOptions() {
        return (Optional<List<PaymentMethod>>) sourceOptions;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<PaymentMethod>> destinationOptions() {
        return (Optional<List<PaymentMethod>>) destinationOptions;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public TransferOptions withSourceOptions(List<PaymentMethod> sourceOptions) {
        Utils.checkNotNull(sourceOptions, "sourceOptions");
        this.sourceOptions = Optional.ofNullable(sourceOptions);
        return this;
    }

    public TransferOptions withSourceOptions(Optional<? extends List<PaymentMethod>> sourceOptions) {
        Utils.checkNotNull(sourceOptions, "sourceOptions");
        this.sourceOptions = sourceOptions;
        return this;
    }

    public TransferOptions withDestinationOptions(List<PaymentMethod> destinationOptions) {
        Utils.checkNotNull(destinationOptions, "destinationOptions");
        this.destinationOptions = Optional.ofNullable(destinationOptions);
        return this;
    }

    public TransferOptions withDestinationOptions(Optional<? extends List<PaymentMethod>> destinationOptions) {
        Utils.checkNotNull(destinationOptions, "destinationOptions");
        this.destinationOptions = destinationOptions;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferOptions other = (TransferOptions) o;
        return 
            Objects.deepEquals(this.sourceOptions, other.sourceOptions) &&
            Objects.deepEquals(this.destinationOptions, other.destinationOptions);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            sourceOptions,
            destinationOptions);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TransferOptions.class,
                "sourceOptions", sourceOptions,
                "destinationOptions", destinationOptions);
    }
    
    public final static class Builder {
 
        private Optional<? extends List<PaymentMethod>> sourceOptions = Optional.empty();
 
        private Optional<? extends List<PaymentMethod>> destinationOptions = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder sourceOptions(List<PaymentMethod> sourceOptions) {
            Utils.checkNotNull(sourceOptions, "sourceOptions");
            this.sourceOptions = Optional.ofNullable(sourceOptions);
            return this;
        }

        public Builder sourceOptions(Optional<? extends List<PaymentMethod>> sourceOptions) {
            Utils.checkNotNull(sourceOptions, "sourceOptions");
            this.sourceOptions = sourceOptions;
            return this;
        }

        public Builder destinationOptions(List<PaymentMethod> destinationOptions) {
            Utils.checkNotNull(destinationOptions, "destinationOptions");
            this.destinationOptions = Optional.ofNullable(destinationOptions);
            return this;
        }

        public Builder destinationOptions(Optional<? extends List<PaymentMethod>> destinationOptions) {
            Utils.checkNotNull(destinationOptions, "destinationOptions");
            this.destinationOptions = destinationOptions;
            return this;
        }
        
        public TransferOptions build() {
            return new TransferOptions(
                sourceOptions,
                destinationOptions);
        }
    }
}
