/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class TermsOfServiceError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("token")
    private Optional<String> token;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("manual")
    private Optional<? extends Manual> manual;

    @JsonCreator
    public TermsOfServiceError(
            @JsonProperty("token") Optional<String> token,
            @JsonProperty("manual") Optional<? extends Manual> manual) {
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(manual, "manual");
        this.token = token;
        this.manual = manual;
    }
    
    public TermsOfServiceError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> token() {
        return token;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Manual> manual() {
        return (Optional<Manual>) manual;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public TermsOfServiceError withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public TermsOfServiceError withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public TermsOfServiceError withManual(Manual manual) {
        Utils.checkNotNull(manual, "manual");
        this.manual = Optional.ofNullable(manual);
        return this;
    }

    public TermsOfServiceError withManual(Optional<? extends Manual> manual) {
        Utils.checkNotNull(manual, "manual");
        this.manual = manual;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TermsOfServiceError other = (TermsOfServiceError) o;
        return 
            Objects.deepEquals(this.token, other.token) &&
            Objects.deepEquals(this.manual, other.manual);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            token,
            manual);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TermsOfServiceError.class,
                "token", token,
                "manual", manual);
    }
    
    public final static class Builder {
 
        private Optional<String> token = Optional.empty();
 
        private Optional<? extends Manual> manual = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder manual(Manual manual) {
            Utils.checkNotNull(manual, "manual");
            this.manual = Optional.ofNullable(manual);
            return this;
        }

        public Builder manual(Optional<? extends Manual> manual) {
            Utils.checkNotNull(manual, "manual");
            this.manual = manual;
            return this;
        }
        
        public TermsOfServiceError build() {
            return new TermsOfServiceError(
                token,
                manual);
        }
    }
}
