/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * TermsOfService
 * 
 * <p>Describes the acceptance of the Terms of Service.
 */
public class TermsOfService {

    /**
     * The date and time the terms of service were accepted.
     */
    @JsonProperty("acceptedDate")
    private OffsetDateTime acceptedDate;

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonProperty("acceptedIP")
    private String acceptedIP;

    @JsonCreator
    public TermsOfService(
            @JsonProperty("acceptedDate") OffsetDateTime acceptedDate,
            @JsonProperty("acceptedIP") String acceptedIP) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        this.acceptedDate = acceptedDate;
        this.acceptedIP = acceptedIP;
    }

    /**
     * The date and time the terms of service were accepted.
     */
    @JsonIgnore
    public OffsetDateTime acceptedDate() {
        return acceptedDate;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    @JsonIgnore
    public String acceptedIP() {
        return acceptedIP;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The date and time the terms of service were accepted.
     */
    public TermsOfService withAcceptedDate(OffsetDateTime acceptedDate) {
        Utils.checkNotNull(acceptedDate, "acceptedDate");
        this.acceptedDate = acceptedDate;
        return this;
    }

    /**
     * The IP address from which the terms of service were accepted.
     */
    public TermsOfService withAcceptedIP(String acceptedIP) {
        Utils.checkNotNull(acceptedIP, "acceptedIP");
        this.acceptedIP = acceptedIP;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TermsOfService other = (TermsOfService) o;
        return 
            Objects.deepEquals(this.acceptedDate, other.acceptedDate) &&
            Objects.deepEquals(this.acceptedIP, other.acceptedIP);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            acceptedDate,
            acceptedIP);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TermsOfService.class,
                "acceptedDate", acceptedDate,
                "acceptedIP", acceptedIP);
    }
    
    public final static class Builder {
 
        private OffsetDateTime acceptedDate;
 
        private String acceptedIP;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The date and time the terms of service were accepted.
         */
        public Builder acceptedDate(OffsetDateTime acceptedDate) {
            Utils.checkNotNull(acceptedDate, "acceptedDate");
            this.acceptedDate = acceptedDate;
            return this;
        }

        /**
         * The IP address from which the terms of service were accepted.
         */
        public Builder acceptedIP(String acceptedIP) {
            Utils.checkNotNull(acceptedIP, "acceptedIP");
            this.acceptedIP = acceptedIP;
            return this;
        }
        
        public TermsOfService build() {
            return new TermsOfService(
                acceptedDate,
                acceptedIP);
        }
    }
}
