/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SweepConfig {

    @JsonProperty("sweepConfigID")
    private String sweepConfigID;

    @JsonProperty("walletID")
    private String walletID;

    @JsonProperty("status")
    private SweepConfigStatus status;

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    @JsonProperty("pushPaymentMethod")
    private SweepConfigPaymentMethod pushPaymentMethod;

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    @JsonProperty("pullPaymentMethod")
    private SweepConfigPaymentMethod pullPaymentMethod;

    /**
     * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("minimumBalance")
    private Optional<String> minimumBalance;

    /**
     * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("statementDescriptor")
    private Optional<String> statementDescriptor;

    /**
     * An array of fields that are locked. To request updates, please contact Moov support.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lockedFields")
    private Optional<? extends List<String>> lockedFields;

    @JsonProperty("createdOn")
    private OffsetDateTime createdOn;

    @JsonProperty("updatedOn")
    private OffsetDateTime updatedOn;

    @JsonCreator
    public SweepConfig(
            @JsonProperty("sweepConfigID") String sweepConfigID,
            @JsonProperty("walletID") String walletID,
            @JsonProperty("status") SweepConfigStatus status,
            @JsonProperty("pushPaymentMethod") SweepConfigPaymentMethod pushPaymentMethod,
            @JsonProperty("pullPaymentMethod") SweepConfigPaymentMethod pullPaymentMethod,
            @JsonProperty("minimumBalance") Optional<String> minimumBalance,
            @JsonProperty("statementDescriptor") Optional<String> statementDescriptor,
            @JsonProperty("lockedFields") Optional<? extends List<String>> lockedFields,
            @JsonProperty("createdOn") OffsetDateTime createdOn,
            @JsonProperty("updatedOn") OffsetDateTime updatedOn) {
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(pushPaymentMethod, "pushPaymentMethod");
        Utils.checkNotNull(pullPaymentMethod, "pullPaymentMethod");
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        Utils.checkNotNull(lockedFields, "lockedFields");
        Utils.checkNotNull(createdOn, "createdOn");
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.sweepConfigID = sweepConfigID;
        this.walletID = walletID;
        this.status = status;
        this.pushPaymentMethod = pushPaymentMethod;
        this.pullPaymentMethod = pullPaymentMethod;
        this.minimumBalance = minimumBalance;
        this.statementDescriptor = statementDescriptor;
        this.lockedFields = lockedFields;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
    }
    
    public SweepConfig(
            String sweepConfigID,
            String walletID,
            SweepConfigStatus status,
            SweepConfigPaymentMethod pushPaymentMethod,
            SweepConfigPaymentMethod pullPaymentMethod,
            OffsetDateTime createdOn,
            OffsetDateTime updatedOn) {
        this(sweepConfigID, walletID, status, pushPaymentMethod, pullPaymentMethod, Optional.empty(), Optional.empty(), Optional.empty(), createdOn, updatedOn);
    }

    @JsonIgnore
    public String sweepConfigID() {
        return sweepConfigID;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public SweepConfigStatus status() {
        return status;
    }

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    @JsonIgnore
    public SweepConfigPaymentMethod pushPaymentMethod() {
        return pushPaymentMethod;
    }

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    @JsonIgnore
    public SweepConfigPaymentMethod pullPaymentMethod() {
        return pullPaymentMethod;
    }

    /**
     * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
     */
    @JsonIgnore
    public Optional<String> minimumBalance() {
        return minimumBalance;
    }

    /**
     * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
     */
    @JsonIgnore
    public Optional<String> statementDescriptor() {
        return statementDescriptor;
    }

    /**
     * An array of fields that are locked. To request updates, please contact Moov support.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> lockedFields() {
        return (Optional<List<String>>) lockedFields;
    }

    @JsonIgnore
    public OffsetDateTime createdOn() {
        return createdOn;
    }

    @JsonIgnore
    public OffsetDateTime updatedOn() {
        return updatedOn;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public SweepConfig withSweepConfigID(String sweepConfigID) {
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        this.sweepConfigID = sweepConfigID;
        return this;
    }

    public SweepConfig withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public SweepConfig withStatus(SweepConfigStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    public SweepConfig withPushPaymentMethod(SweepConfigPaymentMethod pushPaymentMethod) {
        Utils.checkNotNull(pushPaymentMethod, "pushPaymentMethod");
        this.pushPaymentMethod = pushPaymentMethod;
        return this;
    }

    /**
     * The payment method used to push or pull funds to a bank account.
     * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
     */
    public SweepConfig withPullPaymentMethod(SweepConfigPaymentMethod pullPaymentMethod) {
        Utils.checkNotNull(pullPaymentMethod, "pullPaymentMethod");
        this.pullPaymentMethod = pullPaymentMethod;
        return this;
    }

    /**
     * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
     */
    public SweepConfig withMinimumBalance(String minimumBalance) {
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        this.minimumBalance = Optional.ofNullable(minimumBalance);
        return this;
    }

    /**
     * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
     */
    public SweepConfig withMinimumBalance(Optional<String> minimumBalance) {
        Utils.checkNotNull(minimumBalance, "minimumBalance");
        this.minimumBalance = minimumBalance;
        return this;
    }

    /**
     * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
     */
    public SweepConfig withStatementDescriptor(String statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = Optional.ofNullable(statementDescriptor);
        return this;
    }

    /**
     * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
     */
    public SweepConfig withStatementDescriptor(Optional<String> statementDescriptor) {
        Utils.checkNotNull(statementDescriptor, "statementDescriptor");
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    /**
     * An array of fields that are locked. To request updates, please contact Moov support.
     */
    public SweepConfig withLockedFields(List<String> lockedFields) {
        Utils.checkNotNull(lockedFields, "lockedFields");
        this.lockedFields = Optional.ofNullable(lockedFields);
        return this;
    }

    /**
     * An array of fields that are locked. To request updates, please contact Moov support.
     */
    public SweepConfig withLockedFields(Optional<? extends List<String>> lockedFields) {
        Utils.checkNotNull(lockedFields, "lockedFields");
        this.lockedFields = lockedFields;
        return this;
    }

    public SweepConfig withCreatedOn(OffsetDateTime createdOn) {
        Utils.checkNotNull(createdOn, "createdOn");
        this.createdOn = createdOn;
        return this;
    }

    public SweepConfig withUpdatedOn(OffsetDateTime updatedOn) {
        Utils.checkNotNull(updatedOn, "updatedOn");
        this.updatedOn = updatedOn;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SweepConfig other = (SweepConfig) o;
        return 
            Objects.deepEquals(this.sweepConfigID, other.sweepConfigID) &&
            Objects.deepEquals(this.walletID, other.walletID) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.pushPaymentMethod, other.pushPaymentMethod) &&
            Objects.deepEquals(this.pullPaymentMethod, other.pullPaymentMethod) &&
            Objects.deepEquals(this.minimumBalance, other.minimumBalance) &&
            Objects.deepEquals(this.statementDescriptor, other.statementDescriptor) &&
            Objects.deepEquals(this.lockedFields, other.lockedFields) &&
            Objects.deepEquals(this.createdOn, other.createdOn) &&
            Objects.deepEquals(this.updatedOn, other.updatedOn);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            sweepConfigID,
            walletID,
            status,
            pushPaymentMethod,
            pullPaymentMethod,
            minimumBalance,
            statementDescriptor,
            lockedFields,
            createdOn,
            updatedOn);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SweepConfig.class,
                "sweepConfigID", sweepConfigID,
                "walletID", walletID,
                "status", status,
                "pushPaymentMethod", pushPaymentMethod,
                "pullPaymentMethod", pullPaymentMethod,
                "minimumBalance", minimumBalance,
                "statementDescriptor", statementDescriptor,
                "lockedFields", lockedFields,
                "createdOn", createdOn,
                "updatedOn", updatedOn);
    }
    
    public final static class Builder {
 
        private String sweepConfigID;
 
        private String walletID;
 
        private SweepConfigStatus status;
 
        private SweepConfigPaymentMethod pushPaymentMethod;
 
        private SweepConfigPaymentMethod pullPaymentMethod;
 
        private Optional<String> minimumBalance = Optional.empty();
 
        private Optional<String> statementDescriptor = Optional.empty();
 
        private Optional<? extends List<String>> lockedFields = Optional.empty();
 
        private OffsetDateTime createdOn;
 
        private OffsetDateTime updatedOn;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder sweepConfigID(String sweepConfigID) {
            Utils.checkNotNull(sweepConfigID, "sweepConfigID");
            this.sweepConfigID = sweepConfigID;
            return this;
        }

        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }

        public Builder status(SweepConfigStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The payment method used to push or pull funds to a bank account.
         * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
         */
        public Builder pushPaymentMethod(SweepConfigPaymentMethod pushPaymentMethod) {
            Utils.checkNotNull(pushPaymentMethod, "pushPaymentMethod");
            this.pushPaymentMethod = pushPaymentMethod;
            return this;
        }

        /**
         * The payment method used to push or pull funds to a bank account.
         * The push payment method can only be ach-credit-standard or ach-credit-same-day. The pull payment method can only be ach-debit-fund.
         */
        public Builder pullPaymentMethod(SweepConfigPaymentMethod pullPaymentMethod) {
            Utils.checkNotNull(pullPaymentMethod, "pullPaymentMethod");
            this.pullPaymentMethod = pullPaymentMethod;
            return this;
        }

        /**
         * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
         */
        public Builder minimumBalance(String minimumBalance) {
            Utils.checkNotNull(minimumBalance, "minimumBalance");
            this.minimumBalance = Optional.ofNullable(minimumBalance);
            return this;
        }

        /**
         * An optional field to specify an amount to maintain in the wallet. This is a decimal-formatted numerical string that represents up to 2 decimal place precision. In USD for example, 12.34 is $12.34 and 0.99 is $0.99. If not supplied, the default is 0.00.
         */
        public Builder minimumBalance(Optional<String> minimumBalance) {
            Utils.checkNotNull(minimumBalance, "minimumBalance");
            this.minimumBalance = minimumBalance;
            return this;
        }

        /**
         * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
         */
        public Builder statementDescriptor(String statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = Optional.ofNullable(statementDescriptor);
            return this;
        }

        /**
         * The text that appears on the banking statement. The default descriptor is a 10 character ID if an override is not set in the sweep configs statementDescriptor.
         */
        public Builder statementDescriptor(Optional<String> statementDescriptor) {
            Utils.checkNotNull(statementDescriptor, "statementDescriptor");
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        /**
         * An array of fields that are locked. To request updates, please contact Moov support.
         */
        public Builder lockedFields(List<String> lockedFields) {
            Utils.checkNotNull(lockedFields, "lockedFields");
            this.lockedFields = Optional.ofNullable(lockedFields);
            return this;
        }

        /**
         * An array of fields that are locked. To request updates, please contact Moov support.
         */
        public Builder lockedFields(Optional<? extends List<String>> lockedFields) {
            Utils.checkNotNull(lockedFields, "lockedFields");
            this.lockedFields = lockedFields;
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            Utils.checkNotNull(createdOn, "createdOn");
            this.createdOn = createdOn;
            return this;
        }

        public Builder updatedOn(OffsetDateTime updatedOn) {
            Utils.checkNotNull(updatedOn, "updatedOn");
            this.updatedOn = updatedOn;
            return this;
        }
        
        public SweepConfig build() {
            return new SweepConfig(
                sweepConfigID,
                walletID,
                status,
                pushPaymentMethod,
                pullPaymentMethod,
                minimumBalance,
                statementDescriptor,
                lockedFields,
                createdOn,
                updatedOn);
        }
    }
}
