/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * Settings
 * 
 * <p>User provided settings to manage an account.
 */
public class Settings {

    /**
     * User provided settings to manage card payments. This data is only allowed on a business account.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardPayment")
    private Optional<? extends CardPaymentSettings> cardPayment;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("achPayment")
    private Optional<? extends ACHPaymentSettings> achPayment;

    @JsonCreator
    public Settings(
            @JsonProperty("cardPayment") Optional<? extends CardPaymentSettings> cardPayment,
            @JsonProperty("achPayment") Optional<? extends ACHPaymentSettings> achPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        Utils.checkNotNull(achPayment, "achPayment");
        this.cardPayment = cardPayment;
        this.achPayment = achPayment;
    }
    
    public Settings() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * User provided settings to manage card payments. This data is only allowed on a business account.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardPaymentSettings> cardPayment() {
        return (Optional<CardPaymentSettings>) cardPayment;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ACHPaymentSettings> achPayment() {
        return (Optional<ACHPaymentSettings>) achPayment;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * User provided settings to manage card payments. This data is only allowed on a business account.
     */
    public Settings withCardPayment(CardPaymentSettings cardPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        this.cardPayment = Optional.ofNullable(cardPayment);
        return this;
    }

    /**
     * User provided settings to manage card payments. This data is only allowed on a business account.
     */
    public Settings withCardPayment(Optional<? extends CardPaymentSettings> cardPayment) {
        Utils.checkNotNull(cardPayment, "cardPayment");
        this.cardPayment = cardPayment;
        return this;
    }

    public Settings withAchPayment(ACHPaymentSettings achPayment) {
        Utils.checkNotNull(achPayment, "achPayment");
        this.achPayment = Optional.ofNullable(achPayment);
        return this;
    }

    public Settings withAchPayment(Optional<? extends ACHPaymentSettings> achPayment) {
        Utils.checkNotNull(achPayment, "achPayment");
        this.achPayment = achPayment;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Settings other = (Settings) o;
        return 
            Objects.deepEquals(this.cardPayment, other.cardPayment) &&
            Objects.deepEquals(this.achPayment, other.achPayment);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            cardPayment,
            achPayment);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Settings.class,
                "cardPayment", cardPayment,
                "achPayment", achPayment);
    }
    
    public final static class Builder {
 
        private Optional<? extends CardPaymentSettings> cardPayment = Optional.empty();
 
        private Optional<? extends ACHPaymentSettings> achPayment = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * User provided settings to manage card payments. This data is only allowed on a business account.
         */
        public Builder cardPayment(CardPaymentSettings cardPayment) {
            Utils.checkNotNull(cardPayment, "cardPayment");
            this.cardPayment = Optional.ofNullable(cardPayment);
            return this;
        }

        /**
         * User provided settings to manage card payments. This data is only allowed on a business account.
         */
        public Builder cardPayment(Optional<? extends CardPaymentSettings> cardPayment) {
            Utils.checkNotNull(cardPayment, "cardPayment");
            this.cardPayment = cardPayment;
            return this;
        }

        public Builder achPayment(ACHPaymentSettings achPayment) {
            Utils.checkNotNull(achPayment, "achPayment");
            this.achPayment = Optional.ofNullable(achPayment);
            return this;
        }

        public Builder achPayment(Optional<? extends ACHPaymentSettings> achPayment) {
            Utils.checkNotNull(achPayment, "achPayment");
            this.achPayment = achPayment;
            return this;
        }
        
        public Settings build() {
            return new Settings(
                cardPayment,
                achPayment);
        }
    }
}
