/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class SchedulePaymentMethod {

    @JsonProperty("paymentMethodID")
    private String paymentMethodID;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("achDetails")
    private Optional<? extends AchDetails> achDetails;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cardDetails")
    private Optional<? extends CardDetails> cardDetails;

    @JsonCreator
    public SchedulePaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("achDetails") Optional<? extends AchDetails> achDetails,
            @JsonProperty("cardDetails") Optional<? extends CardDetails> cardDetails) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(achDetails, "achDetails");
        Utils.checkNotNull(cardDetails, "cardDetails");
        this.paymentMethodID = paymentMethodID;
        this.achDetails = achDetails;
        this.cardDetails = cardDetails;
    }
    
    public SchedulePaymentMethod(
            String paymentMethodID) {
        this(paymentMethodID, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AchDetails> achDetails() {
        return (Optional<AchDetails>) achDetails;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CardDetails> cardDetails() {
        return (Optional<CardDetails>) cardDetails;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public SchedulePaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    public SchedulePaymentMethod withAchDetails(AchDetails achDetails) {
        Utils.checkNotNull(achDetails, "achDetails");
        this.achDetails = Optional.ofNullable(achDetails);
        return this;
    }

    public SchedulePaymentMethod withAchDetails(Optional<? extends AchDetails> achDetails) {
        Utils.checkNotNull(achDetails, "achDetails");
        this.achDetails = achDetails;
        return this;
    }

    public SchedulePaymentMethod withCardDetails(CardDetails cardDetails) {
        Utils.checkNotNull(cardDetails, "cardDetails");
        this.cardDetails = Optional.ofNullable(cardDetails);
        return this;
    }

    public SchedulePaymentMethod withCardDetails(Optional<? extends CardDetails> cardDetails) {
        Utils.checkNotNull(cardDetails, "cardDetails");
        this.cardDetails = cardDetails;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchedulePaymentMethod other = (SchedulePaymentMethod) o;
        return 
            Objects.deepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Objects.deepEquals(this.achDetails, other.achDetails) &&
            Objects.deepEquals(this.cardDetails, other.cardDetails);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            paymentMethodID,
            achDetails,
            cardDetails);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SchedulePaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "achDetails", achDetails,
                "cardDetails", cardDetails);
    }
    
    public final static class Builder {
 
        private String paymentMethodID;
 
        private Optional<? extends AchDetails> achDetails = Optional.empty();
 
        private Optional<? extends CardDetails> cardDetails = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        public Builder achDetails(AchDetails achDetails) {
            Utils.checkNotNull(achDetails, "achDetails");
            this.achDetails = Optional.ofNullable(achDetails);
            return this;
        }

        public Builder achDetails(Optional<? extends AchDetails> achDetails) {
            Utils.checkNotNull(achDetails, "achDetails");
            this.achDetails = achDetails;
            return this;
        }

        public Builder cardDetails(CardDetails cardDetails) {
            Utils.checkNotNull(cardDetails, "cardDetails");
            this.cardDetails = Optional.ofNullable(cardDetails);
            return this;
        }

        public Builder cardDetails(Optional<? extends CardDetails> cardDetails) {
            Utils.checkNotNull(cardDetails, "cardDetails");
            this.cardDetails = cardDetails;
            return this;
        }
        
        public SchedulePaymentMethod build() {
            return new SchedulePaymentMethod(
                paymentMethodID,
                achDetails,
                cardDetails);
        }
    }
}
