/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * RunTransfer
 * 
 * <p>Defines the attributes of a transfer.
 */
public class RunTransfer {

    @JsonProperty("amount")
    private Amount amount;

    @JsonProperty("destination")
    private SchedulePaymentMethod destination;

    @JsonProperty("partnerAccountID")
    private String partnerAccountID;

    @JsonProperty("source")
    private SchedulePaymentMethod source;

    /**
     * Simple description to place on the transfer.
     */
    @JsonProperty("description")
    private String description;

    @JsonCreator
    public RunTransfer(
            @JsonProperty("amount") Amount amount,
            @JsonProperty("destination") SchedulePaymentMethod destination,
            @JsonProperty("partnerAccountID") String partnerAccountID,
            @JsonProperty("source") SchedulePaymentMethod source,
            @JsonProperty("description") String description) {
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(destination, "destination");
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(description, "description");
        this.amount = amount;
        this.destination = destination;
        this.partnerAccountID = partnerAccountID;
        this.source = source;
        this.description = description;
    }

    @JsonIgnore
    public Amount amount() {
        return amount;
    }

    @JsonIgnore
    public SchedulePaymentMethod destination() {
        return destination;
    }

    @JsonIgnore
    public String partnerAccountID() {
        return partnerAccountID;
    }

    @JsonIgnore
    public SchedulePaymentMethod source() {
        return source;
    }

    /**
     * Simple description to place on the transfer.
     */
    @JsonIgnore
    public String description() {
        return description;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public RunTransfer withAmount(Amount amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    public RunTransfer withDestination(SchedulePaymentMethod destination) {
        Utils.checkNotNull(destination, "destination");
        this.destination = destination;
        return this;
    }

    public RunTransfer withPartnerAccountID(String partnerAccountID) {
        Utils.checkNotNull(partnerAccountID, "partnerAccountID");
        this.partnerAccountID = partnerAccountID;
        return this;
    }

    public RunTransfer withSource(SchedulePaymentMethod source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    /**
     * Simple description to place on the transfer.
     */
    public RunTransfer withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RunTransfer other = (RunTransfer) o;
        return 
            Objects.deepEquals(this.amount, other.amount) &&
            Objects.deepEquals(this.destination, other.destination) &&
            Objects.deepEquals(this.partnerAccountID, other.partnerAccountID) &&
            Objects.deepEquals(this.source, other.source) &&
            Objects.deepEquals(this.description, other.description);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            amount,
            destination,
            partnerAccountID,
            source,
            description);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RunTransfer.class,
                "amount", amount,
                "destination", destination,
                "partnerAccountID", partnerAccountID,
                "source", source,
                "description", description);
    }
    
    public final static class Builder {
 
        private Amount amount;
 
        private SchedulePaymentMethod destination;
 
        private String partnerAccountID;
 
        private SchedulePaymentMethod source;
 
        private String description;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder amount(Amount amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }

        public Builder destination(SchedulePaymentMethod destination) {
            Utils.checkNotNull(destination, "destination");
            this.destination = destination;
            return this;
        }

        public Builder partnerAccountID(String partnerAccountID) {
            Utils.checkNotNull(partnerAccountID, "partnerAccountID");
            this.partnerAccountID = partnerAccountID;
            return this;
        }

        public Builder source(SchedulePaymentMethod source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }

        /**
         * Simple description to place on the transfer.
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }
        
        public RunTransfer build() {
            return new RunTransfer(
                amount,
                destination,
                partnerAccountID,
                source,
                description);
        }
    }
}
