/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class RevokeTokenRequest {

    /**
     * The access or refresh token to revoke.
     */
    @JsonProperty("token")
    @SpeakeasyMetadata("form:name=token")
    private String token;

    /**
     * The type of token being revoked.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("token_type_hint")
    @SpeakeasyMetadata("form:name=token_type_hint")
    private Optional<? extends TokenTypeHint> tokenTypeHint;

    /**
     * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("client_id")
    @SpeakeasyMetadata("form:name=client_id")
    private Optional<String> clientId;

    /**
     * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("client_secret")
    @SpeakeasyMetadata("form:name=client_secret")
    private Optional<String> clientSecret;

    @JsonCreator
    public RevokeTokenRequest(
            @JsonProperty("token") String token,
            @JsonProperty("token_type_hint") Optional<? extends TokenTypeHint> tokenTypeHint,
            @JsonProperty("client_id") Optional<String> clientId,
            @JsonProperty("client_secret") Optional<String> clientSecret) {
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.token = token;
        this.tokenTypeHint = tokenTypeHint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }
    
    public RevokeTokenRequest(
            String token) {
        this(token, Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The access or refresh token to revoke.
     */
    @JsonIgnore
    public String token() {
        return token;
    }

    /**
     * The type of token being revoked.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TokenTypeHint> tokenTypeHint() {
        return (Optional<TokenTypeHint>) tokenTypeHint;
    }

    /**
     * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
     */
    @JsonIgnore
    public Optional<String> clientId() {
        return clientId;
    }

    /**
     * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
     */
    @JsonIgnore
    public Optional<String> clientSecret() {
        return clientSecret;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The access or refresh token to revoke.
     */
    public RevokeTokenRequest withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    /**
     * The type of token being revoked.
     */
    public RevokeTokenRequest withTokenTypeHint(TokenTypeHint tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = Optional.ofNullable(tokenTypeHint);
        return this;
    }

    /**
     * The type of token being revoked.
     */
    public RevokeTokenRequest withTokenTypeHint(Optional<? extends TokenTypeHint> tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = tokenTypeHint;
        return this;
    }

    /**
     * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
     */
    public RevokeTokenRequest withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    /**
     * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
     */
    public RevokeTokenRequest withClientId(Optional<String> clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    /**
     * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
     */
    public RevokeTokenRequest withClientSecret(String clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = Optional.ofNullable(clientSecret);
        return this;
    }

    /**
     * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
     */
    public RevokeTokenRequest withClientSecret(Optional<String> clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RevokeTokenRequest other = (RevokeTokenRequest) o;
        return 
            Objects.deepEquals(this.token, other.token) &&
            Objects.deepEquals(this.tokenTypeHint, other.tokenTypeHint) &&
            Objects.deepEquals(this.clientId, other.clientId) &&
            Objects.deepEquals(this.clientSecret, other.clientSecret);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            token,
            tokenTypeHint,
            clientId,
            clientSecret);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RevokeTokenRequest.class,
                "token", token,
                "tokenTypeHint", tokenTypeHint,
                "clientId", clientId,
                "clientSecret", clientSecret);
    }
    
    public final static class Builder {
 
        private String token;
 
        private Optional<? extends TokenTypeHint> tokenTypeHint = Optional.empty();
 
        private Optional<String> clientId = Optional.empty();
 
        private Optional<String> clientSecret = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The access or refresh token to revoke.
         */
        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        /**
         * The type of token being revoked.
         */
        public Builder tokenTypeHint(TokenTypeHint tokenTypeHint) {
            Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
            this.tokenTypeHint = Optional.ofNullable(tokenTypeHint);
            return this;
        }

        /**
         * The type of token being revoked.
         */
        public Builder tokenTypeHint(Optional<? extends TokenTypeHint> tokenTypeHint) {
            Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
            this.tokenTypeHint = tokenTypeHint;
            return this;
        }

        /**
         * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
         */
        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        /**
         * Client ID can be provided here in the body, or as the Username in HTTP Basic Auth.
         */
        public Builder clientId(Optional<String> clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        /**
         * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
         */
        public Builder clientSecret(String clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        /**
         * Client secret can be provided here in the body, or as the Password in HTTP Basic Auth.
         */
        public Builder clientSecret(Optional<String> clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = clientSecret;
            return this;
        }
        
        public RevokeTokenRequest build() {
            return new RevokeTokenRequest(
                token,
                tokenTypeHint,
                clientId,
                clientSecret);
        }
    }
}
