/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class RequirementError {

    /**
     * The unique ID of what the requirement is asking to be filled out.
     */
    @JsonProperty("requirement")
    private RequirementID requirement;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("errorCode")
    private Optional<? extends RequirementErrorCode> errorCode;

    @JsonCreator
    public RequirementError(
            @JsonProperty("requirement") RequirementID requirement,
            @JsonProperty("errorCode") Optional<? extends RequirementErrorCode> errorCode) {
        Utils.checkNotNull(requirement, "requirement");
        Utils.checkNotNull(errorCode, "errorCode");
        this.requirement = requirement;
        this.errorCode = errorCode;
    }
    
    public RequirementError(
            RequirementID requirement) {
        this(requirement, Optional.empty());
    }

    /**
     * The unique ID of what the requirement is asking to be filled out.
     */
    @JsonIgnore
    public RequirementID requirement() {
        return requirement;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<RequirementErrorCode> errorCode() {
        return (Optional<RequirementErrorCode>) errorCode;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unique ID of what the requirement is asking to be filled out.
     */
    public RequirementError withRequirement(RequirementID requirement) {
        Utils.checkNotNull(requirement, "requirement");
        this.requirement = requirement;
        return this;
    }

    public RequirementError withErrorCode(RequirementErrorCode errorCode) {
        Utils.checkNotNull(errorCode, "errorCode");
        this.errorCode = Optional.ofNullable(errorCode);
        return this;
    }

    public RequirementError withErrorCode(Optional<? extends RequirementErrorCode> errorCode) {
        Utils.checkNotNull(errorCode, "errorCode");
        this.errorCode = errorCode;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequirementError other = (RequirementError) o;
        return 
            Objects.deepEquals(this.requirement, other.requirement) &&
            Objects.deepEquals(this.errorCode, other.errorCode);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            requirement,
            errorCode);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RequirementError.class,
                "requirement", requirement,
                "errorCode", errorCode);
    }
    
    public final static class Builder {
 
        private RequirementID requirement;
 
        private Optional<? extends RequirementErrorCode> errorCode = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unique ID of what the requirement is asking to be filled out.
         */
        public Builder requirement(RequirementID requirement) {
            Utils.checkNotNull(requirement, "requirement");
            this.requirement = requirement;
            return this;
        }

        public Builder errorCode(RequirementErrorCode errorCode) {
            Utils.checkNotNull(errorCode, "errorCode");
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        public Builder errorCode(Optional<? extends RequirementErrorCode> errorCode) {
            Utils.checkNotNull(errorCode, "errorCode");
            this.errorCode = errorCode;
            return this;
        }
        
        public RequirementError build() {
            return new RequirementError(
                requirement,
                errorCode);
        }
    }
}
