/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RegisterApplePayMerchantDomains {

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("displayName")
    private Optional<String> displayName;

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("domains")
    private Optional<? extends List<String>> domains;

    @JsonCreator
    public RegisterApplePayMerchantDomains(
            @JsonProperty("displayName") Optional<String> displayName,
            @JsonProperty("domains") Optional<? extends List<String>> domains) {
        Utils.checkNotNull(displayName, "displayName");
        Utils.checkNotNull(domains, "domains");
        this.displayName = displayName;
        this.domains = domains;
    }
    
    public RegisterApplePayMerchantDomains() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    @JsonIgnore
    public Optional<String> displayName() {
        return displayName;
    }

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> domains() {
        return (Optional<List<String>>) domains;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * A UTF-8 string to display in the Buy button.
     */
    public RegisterApplePayMerchantDomains withDisplayName(String displayName) {
        Utils.checkNotNull(displayName, "displayName");
        this.displayName = Optional.ofNullable(displayName);
        return this;
    }

    /**
     * A UTF-8 string to display in the Buy button.
     */
    public RegisterApplePayMerchantDomains withDisplayName(Optional<String> displayName) {
        Utils.checkNotNull(displayName, "displayName");
        this.displayName = displayName;
        return this;
    }

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    public RegisterApplePayMerchantDomains withDomains(List<String> domains) {
        Utils.checkNotNull(domains, "domains");
        this.domains = Optional.ofNullable(domains);
        return this;
    }

    /**
     * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
     */
    public RegisterApplePayMerchantDomains withDomains(Optional<? extends List<String>> domains) {
        Utils.checkNotNull(domains, "domains");
        this.domains = domains;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegisterApplePayMerchantDomains other = (RegisterApplePayMerchantDomains) o;
        return 
            Objects.deepEquals(this.displayName, other.displayName) &&
            Objects.deepEquals(this.domains, other.domains);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            displayName,
            domains);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RegisterApplePayMerchantDomains.class,
                "displayName", displayName,
                "domains", domains);
    }
    
    public final static class Builder {
 
        private Optional<String> displayName = Optional.empty();
 
        private Optional<? extends List<String>> domains = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * A UTF-8 string to display in the Buy button.
         */
        public Builder displayName(String displayName) {
            Utils.checkNotNull(displayName, "displayName");
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        /**
         * A UTF-8 string to display in the Buy button.
         */
        public Builder displayName(Optional<String> displayName) {
            Utils.checkNotNull(displayName, "displayName");
            this.displayName = displayName;
            return this;
        }

        /**
         * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
         */
        public Builder domains(List<String> domains) {
            Utils.checkNotNull(domains, "domains");
            this.domains = Optional.ofNullable(domains);
            return this;
        }

        /**
         * A unique list of fully-qualified, top-level or sub-domain names where you will accept Apple Pay.
         */
        public Builder domains(Optional<? extends List<String>> domains) {
            Utils.checkNotNull(domains, "domains");
            this.domains = domains;
            return this;
        }
        
        public RegisterApplePayMerchantDomains build() {
            return new RegisterApplePayMerchantDomains(
                displayName,
                domains);
        }
    }
}
