/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;

/**
 * ReceiptRequest
 * 
 * <p>A receipt request for a specific transfer, schedule, or schedule occurrence.
 */
public class ReceiptRequest {

    /**
     * The type of receipt being requested.
     */
    @JsonProperty("kind")
    private ReceiptKind kind;

    /**
     * The email address to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("email")
    private Optional<String> email;

    /**
     * The accountID to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("emailAccountID")
    private Optional<String> emailAccountID;

    /**
     * The ID of the transfer associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("forTransferID")
    private Optional<String> forTransferID;

    /**
     * The ID of the schedule associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("forScheduleID")
    private Optional<String> forScheduleID;

    /**
     * The ID of the schedule occurrence associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("forOccurrenceID")
    private Optional<String> forOccurrenceID;

    @JsonCreator
    public ReceiptRequest(
            @JsonProperty("kind") ReceiptKind kind,
            @JsonProperty("email") Optional<String> email,
            @JsonProperty("emailAccountID") Optional<String> emailAccountID,
            @JsonProperty("forTransferID") Optional<String> forTransferID,
            @JsonProperty("forScheduleID") Optional<String> forScheduleID,
            @JsonProperty("forOccurrenceID") Optional<String> forOccurrenceID) {
        Utils.checkNotNull(kind, "kind");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(emailAccountID, "emailAccountID");
        Utils.checkNotNull(forTransferID, "forTransferID");
        Utils.checkNotNull(forScheduleID, "forScheduleID");
        Utils.checkNotNull(forOccurrenceID, "forOccurrenceID");
        this.kind = kind;
        this.email = email;
        this.emailAccountID = emailAccountID;
        this.forTransferID = forTransferID;
        this.forScheduleID = forScheduleID;
        this.forOccurrenceID = forOccurrenceID;
    }
    
    public ReceiptRequest(
            ReceiptKind kind) {
        this(kind, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The type of receipt being requested.
     */
    @JsonIgnore
    public ReceiptKind kind() {
        return kind;
    }

    /**
     * The email address to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    @JsonIgnore
    public Optional<String> email() {
        return email;
    }

    /**
     * The accountID to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    @JsonIgnore
    public Optional<String> emailAccountID() {
        return emailAccountID;
    }

    /**
     * The ID of the transfer associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonIgnore
    public Optional<String> forTransferID() {
        return forTransferID;
    }

    /**
     * The ID of the schedule associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonIgnore
    public Optional<String> forScheduleID() {
        return forScheduleID;
    }

    /**
     * The ID of the schedule occurrence associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    @JsonIgnore
    public Optional<String> forOccurrenceID() {
        return forOccurrenceID;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of receipt being requested.
     */
    public ReceiptRequest withKind(ReceiptKind kind) {
        Utils.checkNotNull(kind, "kind");
        this.kind = kind;
        return this;
    }

    /**
     * The email address to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    public ReceiptRequest withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    /**
     * The email address to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    public ReceiptRequest withEmail(Optional<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    /**
     * The accountID to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    public ReceiptRequest withEmailAccountID(String emailAccountID) {
        Utils.checkNotNull(emailAccountID, "emailAccountID");
        this.emailAccountID = Optional.ofNullable(emailAccountID);
        return this;
    }

    /**
     * The accountID to send the receipt to.
     * Either email or emailAccountID must be provided, but not both.
     */
    public ReceiptRequest withEmailAccountID(Optional<String> emailAccountID) {
        Utils.checkNotNull(emailAccountID, "emailAccountID");
        this.emailAccountID = emailAccountID;
        return this;
    }

    /**
     * The ID of the transfer associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForTransferID(String forTransferID) {
        Utils.checkNotNull(forTransferID, "forTransferID");
        this.forTransferID = Optional.ofNullable(forTransferID);
        return this;
    }

    /**
     * The ID of the transfer associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForTransferID(Optional<String> forTransferID) {
        Utils.checkNotNull(forTransferID, "forTransferID");
        this.forTransferID = forTransferID;
        return this;
    }

    /**
     * The ID of the schedule associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForScheduleID(String forScheduleID) {
        Utils.checkNotNull(forScheduleID, "forScheduleID");
        this.forScheduleID = Optional.ofNullable(forScheduleID);
        return this;
    }

    /**
     * The ID of the schedule associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForScheduleID(Optional<String> forScheduleID) {
        Utils.checkNotNull(forScheduleID, "forScheduleID");
        this.forScheduleID = forScheduleID;
        return this;
    }

    /**
     * The ID of the schedule occurrence associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForOccurrenceID(String forOccurrenceID) {
        Utils.checkNotNull(forOccurrenceID, "forOccurrenceID");
        this.forOccurrenceID = Optional.ofNullable(forOccurrenceID);
        return this;
    }

    /**
     * The ID of the schedule occurrence associated with this receipt.
     * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
     */
    public ReceiptRequest withForOccurrenceID(Optional<String> forOccurrenceID) {
        Utils.checkNotNull(forOccurrenceID, "forOccurrenceID");
        this.forOccurrenceID = forOccurrenceID;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceiptRequest other = (ReceiptRequest) o;
        return 
            Objects.deepEquals(this.kind, other.kind) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.emailAccountID, other.emailAccountID) &&
            Objects.deepEquals(this.forTransferID, other.forTransferID) &&
            Objects.deepEquals(this.forScheduleID, other.forScheduleID) &&
            Objects.deepEquals(this.forOccurrenceID, other.forOccurrenceID);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            kind,
            email,
            emailAccountID,
            forTransferID,
            forScheduleID,
            forOccurrenceID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ReceiptRequest.class,
                "kind", kind,
                "email", email,
                "emailAccountID", emailAccountID,
                "forTransferID", forTransferID,
                "forScheduleID", forScheduleID,
                "forOccurrenceID", forOccurrenceID);
    }
    
    public final static class Builder {
 
        private ReceiptKind kind;
 
        private Optional<String> email = Optional.empty();
 
        private Optional<String> emailAccountID = Optional.empty();
 
        private Optional<String> forTransferID = Optional.empty();
 
        private Optional<String> forScheduleID = Optional.empty();
 
        private Optional<String> forOccurrenceID = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of receipt being requested.
         */
        public Builder kind(ReceiptKind kind) {
            Utils.checkNotNull(kind, "kind");
            this.kind = kind;
            return this;
        }

        /**
         * The email address to send the receipt to.
         * Either email or emailAccountID must be provided, but not both.
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * The email address to send the receipt to.
         * Either email or emailAccountID must be provided, but not both.
         */
        public Builder email(Optional<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        /**
         * The accountID to send the receipt to.
         * Either email or emailAccountID must be provided, but not both.
         */
        public Builder emailAccountID(String emailAccountID) {
            Utils.checkNotNull(emailAccountID, "emailAccountID");
            this.emailAccountID = Optional.ofNullable(emailAccountID);
            return this;
        }

        /**
         * The accountID to send the receipt to.
         * Either email or emailAccountID must be provided, but not both.
         */
        public Builder emailAccountID(Optional<String> emailAccountID) {
            Utils.checkNotNull(emailAccountID, "emailAccountID");
            this.emailAccountID = emailAccountID;
            return this;
        }

        /**
         * The ID of the transfer associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forTransferID(String forTransferID) {
            Utils.checkNotNull(forTransferID, "forTransferID");
            this.forTransferID = Optional.ofNullable(forTransferID);
            return this;
        }

        /**
         * The ID of the transfer associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forTransferID(Optional<String> forTransferID) {
            Utils.checkNotNull(forTransferID, "forTransferID");
            this.forTransferID = forTransferID;
            return this;
        }

        /**
         * The ID of the schedule associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forScheduleID(String forScheduleID) {
            Utils.checkNotNull(forScheduleID, "forScheduleID");
            this.forScheduleID = Optional.ofNullable(forScheduleID);
            return this;
        }

        /**
         * The ID of the schedule associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forScheduleID(Optional<String> forScheduleID) {
            Utils.checkNotNull(forScheduleID, "forScheduleID");
            this.forScheduleID = forScheduleID;
            return this;
        }

        /**
         * The ID of the schedule occurrence associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forOccurrenceID(String forOccurrenceID) {
            Utils.checkNotNull(forOccurrenceID, "forOccurrenceID");
            this.forOccurrenceID = Optional.ofNullable(forOccurrenceID);
            return this;
        }

        /**
         * The ID of the schedule occurrence associated with this receipt.
         * Exactly one of forTransferID, forScheduleID, or forOccurrenceID must be provided.
         */
        public Builder forOccurrenceID(Optional<String> forOccurrenceID) {
            Utils.checkNotNull(forOccurrenceID, "forOccurrenceID");
            this.forOccurrenceID = forOccurrenceID;
            return this;
        }
        
        public ReceiptRequest build() {
            return new ReceiptRequest(
                kind,
                email,
                emailAccountID,
                forTransferID,
                forScheduleID,
                forOccurrenceID);
        }
    }
}
