/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RTPInstitution {

    /**
     * Name of the financial institution.
     */
    @JsonProperty("name")
    private String name;

    @JsonProperty("routingNumber")
    private String routingNumber;

    @JsonProperty("services")
    private RTPServices services;

    @JsonCreator
    public RTPInstitution(
            @JsonProperty("name") String name,
            @JsonProperty("routingNumber") String routingNumber,
            @JsonProperty("services") RTPServices services) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(routingNumber, "routingNumber");
        Utils.checkNotNull(services, "services");
        this.name = name;
        this.routingNumber = routingNumber;
        this.services = services;
    }

    /**
     * Name of the financial institution.
     */
    @JsonIgnore
    public String name() {
        return name;
    }

    @JsonIgnore
    public String routingNumber() {
        return routingNumber;
    }

    @JsonIgnore
    public RTPServices services() {
        return services;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Name of the financial institution.
     */
    public RTPInstitution withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public RTPInstitution withRoutingNumber(String routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = routingNumber;
        return this;
    }

    public RTPInstitution withServices(RTPServices services) {
        Utils.checkNotNull(services, "services");
        this.services = services;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RTPInstitution other = (RTPInstitution) o;
        return 
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.routingNumber, other.routingNumber) &&
            Objects.deepEquals(this.services, other.services);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            name,
            routingNumber,
            services);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RTPInstitution.class,
                "name", name,
                "routingNumber", routingNumber,
                "services", services);
    }
    
    public final static class Builder {
 
        private String name;
 
        private String routingNumber;
 
        private RTPServices services;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Name of the financial institution.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder routingNumber(String routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = routingNumber;
            return this;
        }

        public Builder services(RTPServices services) {
            Utils.checkNotNull(services, "services");
            this.services = services;
            return this;
        }
        
        public RTPInstitution build() {
            return new RTPInstitution(
                name,
                routingNumber,
                services);
        }
    }
}
