/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * Profile
 * 
 * <p>Describes a Moov account profile. A profile will have a business or an individual, depending on the account's type.
 */
public class Profile {

    /**
     * Describes an individual.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("individual")
    private Optional<? extends IndividualProfile> individual;

    /**
     * Describes a business.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("business")
    private Optional<? extends BusinessProfile> business;

    /**
     * Describes a guest account profile.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("guest")
    private Optional<? extends GuestProfile> guest;

    @JsonCreator
    public Profile(
            @JsonProperty("individual") Optional<? extends IndividualProfile> individual,
            @JsonProperty("business") Optional<? extends BusinessProfile> business,
            @JsonProperty("guest") Optional<? extends GuestProfile> guest) {
        Utils.checkNotNull(individual, "individual");
        Utils.checkNotNull(business, "business");
        Utils.checkNotNull(guest, "guest");
        this.individual = individual;
        this.business = business;
        this.guest = guest;
    }
    
    public Profile() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * Describes an individual.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IndividualProfile> individual() {
        return (Optional<IndividualProfile>) individual;
    }

    /**
     * Describes a business.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BusinessProfile> business() {
        return (Optional<BusinessProfile>) business;
    }

    /**
     * Describes a guest account profile.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<GuestProfile> guest() {
        return (Optional<GuestProfile>) guest;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Describes an individual.
     */
    public Profile withIndividual(IndividualProfile individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = Optional.ofNullable(individual);
        return this;
    }

    /**
     * Describes an individual.
     */
    public Profile withIndividual(Optional<? extends IndividualProfile> individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = individual;
        return this;
    }

    /**
     * Describes a business.
     */
    public Profile withBusiness(BusinessProfile business) {
        Utils.checkNotNull(business, "business");
        this.business = Optional.ofNullable(business);
        return this;
    }

    /**
     * Describes a business.
     */
    public Profile withBusiness(Optional<? extends BusinessProfile> business) {
        Utils.checkNotNull(business, "business");
        this.business = business;
        return this;
    }

    /**
     * Describes a guest account profile.
     */
    public Profile withGuest(GuestProfile guest) {
        Utils.checkNotNull(guest, "guest");
        this.guest = Optional.ofNullable(guest);
        return this;
    }

    /**
     * Describes a guest account profile.
     */
    public Profile withGuest(Optional<? extends GuestProfile> guest) {
        Utils.checkNotNull(guest, "guest");
        this.guest = guest;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Profile other = (Profile) o;
        return 
            Objects.deepEquals(this.individual, other.individual) &&
            Objects.deepEquals(this.business, other.business) &&
            Objects.deepEquals(this.guest, other.guest);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            individual,
            business,
            guest);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Profile.class,
                "individual", individual,
                "business", business,
                "guest", guest);
    }
    
    public final static class Builder {
 
        private Optional<? extends IndividualProfile> individual = Optional.empty();
 
        private Optional<? extends BusinessProfile> business = Optional.empty();
 
        private Optional<? extends GuestProfile> guest = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Describes an individual.
         */
        public Builder individual(IndividualProfile individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = Optional.ofNullable(individual);
            return this;
        }

        /**
         * Describes an individual.
         */
        public Builder individual(Optional<? extends IndividualProfile> individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = individual;
            return this;
        }

        /**
         * Describes a business.
         */
        public Builder business(BusinessProfile business) {
            Utils.checkNotNull(business, "business");
            this.business = Optional.ofNullable(business);
            return this;
        }

        /**
         * Describes a business.
         */
        public Builder business(Optional<? extends BusinessProfile> business) {
            Utils.checkNotNull(business, "business");
            this.business = business;
            return this;
        }

        /**
         * Describes a guest account profile.
         */
        public Builder guest(GuestProfile guest) {
            Utils.checkNotNull(guest, "guest");
            this.guest = Optional.ofNullable(guest);
            return this;
        }

        /**
         * Describes a guest account profile.
         */
        public Builder guest(Optional<? extends GuestProfile> guest) {
            Utils.checkNotNull(guest, "guest");
            this.guest = guest;
            return this;
        }
        
        public Profile build() {
            return new Profile(
                individual,
                business,
                guest);
        }
    }
}
