/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * PlaidPayload
 * 
 * <p>Describes the account to link to the Moov account using a Plaid processor token.
 */
public class PlaidPayload {

    /**
     * The details of a Plaid processor integration for a linked funding source. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a Plaid processor token a default bank account
     * response will be used. The following default data will be used to generate the bank account in this flow:
     * 
     * <p>```
     *   RoutingNumber: "011401533",
     *   AccountNumber: "1111222233330000",
     *   AccountType:   "checking",
     *   Mask:          "0000"
     * ```
     */
    @JsonProperty("plaid")
    private PlaidIntegration plaid;

    @JsonCreator
    public PlaidPayload(
            @JsonProperty("plaid") PlaidIntegration plaid) {
        Utils.checkNotNull(plaid, "plaid");
        this.plaid = plaid;
    }

    /**
     * The details of a Plaid processor integration for a linked funding source. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a Plaid processor token a default bank account
     * response will be used. The following default data will be used to generate the bank account in this flow:
     * 
     * <p>```
     *   RoutingNumber: "011401533",
     *   AccountNumber: "1111222233330000",
     *   AccountType:   "checking",
     *   Mask:          "0000"
     * ```
     */
    @JsonIgnore
    public PlaidIntegration plaid() {
        return plaid;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The details of a Plaid processor integration for a linked funding source. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a Plaid processor token a default bank account
     * response will be used. The following default data will be used to generate the bank account in this flow:
     * 
     * <p>```
     *   RoutingNumber: "011401533",
     *   AccountNumber: "1111222233330000",
     *   AccountType:   "checking",
     *   Mask:          "0000"
     * ```
     */
    public PlaidPayload withPlaid(PlaidIntegration plaid) {
        Utils.checkNotNull(plaid, "plaid");
        this.plaid = plaid;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlaidPayload other = (PlaidPayload) o;
        return 
            Objects.deepEquals(this.plaid, other.plaid);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            plaid);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PlaidPayload.class,
                "plaid", plaid);
    }
    
    public final static class Builder {
 
        private PlaidIntegration plaid;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The details of a Plaid processor integration for a linked funding source. 
         * 
         * <p>`sandbox` - When linking a bank account to a `sandbox` account using a Plaid processor token a default bank account
         * response will be used. The following default data will be used to generate the bank account in this flow:
         * 
         * <p>```
         *   RoutingNumber: "011401533",
         *   AccountNumber: "1111222233330000",
         *   AccountType:   "checking",
         *   Mask:          "0000"
         * ```
         */
        public Builder plaid(PlaidIntegration plaid) {
            Utils.checkNotNull(plaid, "plaid");
            this.plaid = plaid;
            return this;
        }
        
        public PlaidPayload build() {
            return new PlaidPayload(
                plaid);
        }
    }
}
