/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * PlaidLinkPayload
 * 
 * <p>This is used by Moov.js with a Plaid reseller relationship. 
 * 
 * <p>Describes the account to link to the Moov account using a Plaid using a Plaid public token.
 */
public class PlaidLinkPayload {

    /**
     * This is used by Moov.js with a Plaid reseller relationship. The details of a Plaid link integration for a linked funding source.
     * 
     * <p>You can simulate linking bank accounts with Plaid in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#plaid)
     * guide for more information.
     * 
     * <p>Plaid's `sandbox` environment - (requires Plaid reseller setup with Moov). When linking a bank account to a `sandbox` account using a Plaid 
     * public token it will utilize Plaid's sandbox environment. The Plaid public token provided must be generated from Plaid's sandbox environment. 
     * Please see &lt;a href="https://plaid.com/docs/api/sandbox/#sandboxpublic_tokencreate" target="_blank"&gt;Plaid's sandbox documentation&lt;/a&gt; for more 
     * details.
     */
    @JsonProperty("plaidLink")
    private PlaidLinkIntegration plaidLink;

    @JsonCreator
    public PlaidLinkPayload(
            @JsonProperty("plaidLink") PlaidLinkIntegration plaidLink) {
        Utils.checkNotNull(plaidLink, "plaidLink");
        this.plaidLink = plaidLink;
    }

    /**
     * This is used by Moov.js with a Plaid reseller relationship. The details of a Plaid link integration for a linked funding source.
     * 
     * <p>You can simulate linking bank accounts with Plaid in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#plaid)
     * guide for more information.
     * 
     * <p>Plaid's `sandbox` environment - (requires Plaid reseller setup with Moov). When linking a bank account to a `sandbox` account using a Plaid 
     * public token it will utilize Plaid's sandbox environment. The Plaid public token provided must be generated from Plaid's sandbox environment. 
     * Please see &lt;a href="https://plaid.com/docs/api/sandbox/#sandboxpublic_tokencreate" target="_blank"&gt;Plaid's sandbox documentation&lt;/a&gt; for more 
     * details.
     */
    @JsonIgnore
    public PlaidLinkIntegration plaidLink() {
        return plaidLink;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * This is used by Moov.js with a Plaid reseller relationship. The details of a Plaid link integration for a linked funding source.
     * 
     * <p>You can simulate linking bank accounts with Plaid in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#plaid)
     * guide for more information.
     * 
     * <p>Plaid's `sandbox` environment - (requires Plaid reseller setup with Moov). When linking a bank account to a `sandbox` account using a Plaid 
     * public token it will utilize Plaid's sandbox environment. The Plaid public token provided must be generated from Plaid's sandbox environment. 
     * Please see &lt;a href="https://plaid.com/docs/api/sandbox/#sandboxpublic_tokencreate" target="_blank"&gt;Plaid's sandbox documentation&lt;/a&gt; for more 
     * details.
     */
    public PlaidLinkPayload withPlaidLink(PlaidLinkIntegration plaidLink) {
        Utils.checkNotNull(plaidLink, "plaidLink");
        this.plaidLink = plaidLink;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlaidLinkPayload other = (PlaidLinkPayload) o;
        return 
            Objects.deepEquals(this.plaidLink, other.plaidLink);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            plaidLink);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PlaidLinkPayload.class,
                "plaidLink", plaidLink);
    }
    
    public final static class Builder {
 
        private PlaidLinkIntegration plaidLink;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * This is used by Moov.js with a Plaid reseller relationship. The details of a Plaid link integration for a linked funding source.
         * 
         * <p>You can simulate linking bank accounts with Plaid in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#plaid)
         * guide for more information.
         * 
         * <p>Plaid's `sandbox` environment - (requires Plaid reseller setup with Moov). When linking a bank account to a `sandbox` account using a Plaid 
         * public token it will utilize Plaid's sandbox environment. The Plaid public token provided must be generated from Plaid's sandbox environment. 
         * Please see &lt;a href="https://plaid.com/docs/api/sandbox/#sandboxpublic_tokencreate" target="_blank"&gt;Plaid's sandbox documentation&lt;/a&gt; for more 
         * details.
         */
        public Builder plaidLink(PlaidLinkIntegration plaidLink) {
            Utils.checkNotNull(plaidLink, "plaidLink");
            this.plaidLink = plaidLink;
            return this;
        }
        
        public PlaidLinkPayload build() {
            return new PlaidLinkPayload(
                plaidLink);
        }
    }
}
