/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * PlaidLinkIntegration
 * 
 * <p>This is used by Moov.js with a Plaid reseller relationship. The details of a Plaid link integration for a linked funding source.
 * 
 * <p>You can simulate linking bank accounts with Plaid in test mode. See our [test mode](https://docs.moov.io/guides/get-started/test-mode/#plaid)
 * guide for more information.
 * 
 * <p>Plaid's `sandbox` environment - (requires Plaid reseller setup with Moov). When linking a bank account to a `sandbox` account using a Plaid 
 * public token it will utilize Plaid's sandbox environment. The Plaid public token provided must be generated from Plaid's sandbox environment. 
 * Please see &lt;a href="https://plaid.com/docs/api/sandbox/#sandboxpublic_tokencreate" target="_blank"&gt;Plaid's sandbox documentation&lt;/a&gt; for more 
 * details.
 */
public class PlaidLinkIntegration {

    @JsonProperty("publicToken")
    private String publicToken;

    @JsonCreator
    public PlaidLinkIntegration(
            @JsonProperty("publicToken") String publicToken) {
        Utils.checkNotNull(publicToken, "publicToken");
        this.publicToken = publicToken;
    }

    @JsonIgnore
    public String publicToken() {
        return publicToken;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public PlaidLinkIntegration withPublicToken(String publicToken) {
        Utils.checkNotNull(publicToken, "publicToken");
        this.publicToken = publicToken;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlaidLinkIntegration other = (PlaidLinkIntegration) o;
        return 
            Objects.deepEquals(this.publicToken, other.publicToken);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            publicToken);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PlaidLinkIntegration.class,
                "publicToken", publicToken);
    }
    
    public final static class Builder {
 
        private String publicToken;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder publicToken(String publicToken) {
            Utils.checkNotNull(publicToken, "publicToken");
            this.publicToken = publicToken;
            return this;
        }
        
        public PlaidLinkIntegration build() {
            return new PlaidLinkIntegration(
                publicToken);
        }
    }
}
