/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

public class PayoutDetailsError {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("allowedMethods")
    private Optional<String> allowedMethods;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recipient")
    private Optional<? extends PayoutRecipientError> recipient;

    @JsonCreator
    public PayoutDetailsError(
            @JsonProperty("allowedMethods") Optional<String> allowedMethods,
            @JsonProperty("recipient") Optional<? extends PayoutRecipientError> recipient) {
        Utils.checkNotNull(allowedMethods, "allowedMethods");
        Utils.checkNotNull(recipient, "recipient");
        this.allowedMethods = allowedMethods;
        this.recipient = recipient;
    }
    
    public PayoutDetailsError() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> allowedMethods() {
        return allowedMethods;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PayoutRecipientError> recipient() {
        return (Optional<PayoutRecipientError>) recipient;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public PayoutDetailsError withAllowedMethods(String allowedMethods) {
        Utils.checkNotNull(allowedMethods, "allowedMethods");
        this.allowedMethods = Optional.ofNullable(allowedMethods);
        return this;
    }

    public PayoutDetailsError withAllowedMethods(Optional<String> allowedMethods) {
        Utils.checkNotNull(allowedMethods, "allowedMethods");
        this.allowedMethods = allowedMethods;
        return this;
    }

    public PayoutDetailsError withRecipient(PayoutRecipientError recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public PayoutDetailsError withRecipient(Optional<? extends PayoutRecipientError> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PayoutDetailsError other = (PayoutDetailsError) o;
        return 
            Objects.deepEquals(this.allowedMethods, other.allowedMethods) &&
            Objects.deepEquals(this.recipient, other.recipient);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            allowedMethods,
            recipient);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PayoutDetailsError.class,
                "allowedMethods", allowedMethods,
                "recipient", recipient);
    }
    
    public final static class Builder {
 
        private Optional<String> allowedMethods = Optional.empty();
 
        private Optional<? extends PayoutRecipientError> recipient = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder allowedMethods(String allowedMethods) {
            Utils.checkNotNull(allowedMethods, "allowedMethods");
            this.allowedMethods = Optional.ofNullable(allowedMethods);
            return this;
        }

        public Builder allowedMethods(Optional<String> allowedMethods) {
            Utils.checkNotNull(allowedMethods, "allowedMethods");
            this.allowedMethods = allowedMethods;
            return this;
        }

        public Builder recipient(PayoutRecipientError recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        public Builder recipient(Optional<? extends PayoutRecipientError> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }
        
        public PayoutDetailsError build() {
            return new PayoutDetailsError(
                allowedMethods,
                recipient);
        }
    }
}
