/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class PaymentLinkPayoutDetails {

    /**
     * A list of payment methods that should be supported for this payment link.
     */
    @JsonProperty("allowedMethods")
    private List<DisbursementPaymentMethodType> allowedMethods;

    /**
     * Specify the intended recipient of the payout.
     * 
     * <p>This information will be used to authenticate the end user when they follow the payment link.
     */
    @JsonProperty("recipient")
    private PayoutRecipient recipient;

    @JsonCreator
    public PaymentLinkPayoutDetails(
            @JsonProperty("allowedMethods") List<DisbursementPaymentMethodType> allowedMethods,
            @JsonProperty("recipient") PayoutRecipient recipient) {
        Utils.checkNotNull(allowedMethods, "allowedMethods");
        Utils.checkNotNull(recipient, "recipient");
        this.allowedMethods = allowedMethods;
        this.recipient = recipient;
    }

    /**
     * A list of payment methods that should be supported for this payment link.
     */
    @JsonIgnore
    public List<DisbursementPaymentMethodType> allowedMethods() {
        return allowedMethods;
    }

    /**
     * Specify the intended recipient of the payout.
     * 
     * <p>This information will be used to authenticate the end user when they follow the payment link.
     */
    @JsonIgnore
    public PayoutRecipient recipient() {
        return recipient;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * A list of payment methods that should be supported for this payment link.
     */
    public PaymentLinkPayoutDetails withAllowedMethods(List<DisbursementPaymentMethodType> allowedMethods) {
        Utils.checkNotNull(allowedMethods, "allowedMethods");
        this.allowedMethods = allowedMethods;
        return this;
    }

    /**
     * Specify the intended recipient of the payout.
     * 
     * <p>This information will be used to authenticate the end user when they follow the payment link.
     */
    public PaymentLinkPayoutDetails withRecipient(PayoutRecipient recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkPayoutDetails other = (PaymentLinkPayoutDetails) o;
        return 
            Objects.deepEquals(this.allowedMethods, other.allowedMethods) &&
            Objects.deepEquals(this.recipient, other.recipient);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            allowedMethods,
            recipient);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PaymentLinkPayoutDetails.class,
                "allowedMethods", allowedMethods,
                "recipient", recipient);
    }
    
    public final static class Builder {
 
        private List<DisbursementPaymentMethodType> allowedMethods;
 
        private PayoutRecipient recipient;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * A list of payment methods that should be supported for this payment link.
         */
        public Builder allowedMethods(List<DisbursementPaymentMethodType> allowedMethods) {
            Utils.checkNotNull(allowedMethods, "allowedMethods");
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Specify the intended recipient of the payout.
         * 
         * <p>This information will be used to authenticate the end user when they follow the payment link.
         */
        public Builder recipient(PayoutRecipient recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }
        
        public PaymentLinkPayoutDetails build() {
            return new PaymentLinkPayoutDetails(
                allowedMethods,
                recipient);
        }
    }
}
