/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * PaymentLinkDisplayOptionsUpdate
 * 
 * <p>Customizable display options for a payment link.
 */
public class PaymentLinkDisplayOptionsUpdate {

    /**
     * The payment page title displayed to the user.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private Optional<String> title;

    /**
     * A payment description displayed to the user.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private Optional<String> description;

    /**
     * The text to be displayed on web form's submit button.
     * 
     * <p>If set to "auto" the UI will automatically select between 
     * "pay" and "confirm" for payments and payouts respectively.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("callToAction")
    private Optional<? extends CallToAction> callToAction;

    @JsonCreator
    public PaymentLinkDisplayOptionsUpdate(
            @JsonProperty("title") Optional<String> title,
            @JsonProperty("description") Optional<String> description,
            @JsonProperty("callToAction") Optional<? extends CallToAction> callToAction) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(callToAction, "callToAction");
        this.title = title;
        this.description = description;
        this.callToAction = callToAction;
    }
    
    public PaymentLinkDisplayOptionsUpdate() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The payment page title displayed to the user.
     */
    @JsonIgnore
    public Optional<String> title() {
        return title;
    }

    /**
     * A payment description displayed to the user.
     */
    @JsonIgnore
    public Optional<String> description() {
        return description;
    }

    /**
     * The text to be displayed on web form's submit button.
     * 
     * <p>If set to "auto" the UI will automatically select between 
     * "pay" and "confirm" for payments and payouts respectively.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CallToAction> callToAction() {
        return (Optional<CallToAction>) callToAction;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The payment page title displayed to the user.
     */
    public PaymentLinkDisplayOptionsUpdate withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = Optional.ofNullable(title);
        return this;
    }

    /**
     * The payment page title displayed to the user.
     */
    public PaymentLinkDisplayOptionsUpdate withTitle(Optional<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * A payment description displayed to the user.
     */
    public PaymentLinkDisplayOptionsUpdate withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = Optional.ofNullable(description);
        return this;
    }

    /**
     * A payment description displayed to the user.
     */
    public PaymentLinkDisplayOptionsUpdate withDescription(Optional<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The text to be displayed on web form's submit button.
     * 
     * <p>If set to "auto" the UI will automatically select between 
     * "pay" and "confirm" for payments and payouts respectively.
     */
    public PaymentLinkDisplayOptionsUpdate withCallToAction(CallToAction callToAction) {
        Utils.checkNotNull(callToAction, "callToAction");
        this.callToAction = Optional.ofNullable(callToAction);
        return this;
    }

    /**
     * The text to be displayed on web form's submit button.
     * 
     * <p>If set to "auto" the UI will automatically select between 
     * "pay" and "confirm" for payments and payouts respectively.
     */
    public PaymentLinkDisplayOptionsUpdate withCallToAction(Optional<? extends CallToAction> callToAction) {
        Utils.checkNotNull(callToAction, "callToAction");
        this.callToAction = callToAction;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkDisplayOptionsUpdate other = (PaymentLinkDisplayOptionsUpdate) o;
        return 
            Objects.deepEquals(this.title, other.title) &&
            Objects.deepEquals(this.description, other.description) &&
            Objects.deepEquals(this.callToAction, other.callToAction);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            title,
            description,
            callToAction);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PaymentLinkDisplayOptionsUpdate.class,
                "title", title,
                "description", description,
                "callToAction", callToAction);
    }
    
    public final static class Builder {
 
        private Optional<String> title = Optional.empty();
 
        private Optional<String> description = Optional.empty();
 
        private Optional<? extends CallToAction> callToAction = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The payment page title displayed to the user.
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * The payment page title displayed to the user.
         */
        public Builder title(Optional<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        /**
         * A payment description displayed to the user.
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * A payment description displayed to the user.
         */
        public Builder description(Optional<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * The text to be displayed on web form's submit button.
         * 
         * <p>If set to "auto" the UI will automatically select between 
         * "pay" and "confirm" for payments and payouts respectively.
         */
        public Builder callToAction(CallToAction callToAction) {
            Utils.checkNotNull(callToAction, "callToAction");
            this.callToAction = Optional.ofNullable(callToAction);
            return this;
        }

        /**
         * The text to be displayed on web form's submit button.
         * 
         * <p>If set to "auto" the UI will automatically select between 
         * "pay" and "confirm" for payments and payouts respectively.
         */
        public Builder callToAction(Optional<? extends CallToAction> callToAction) {
            Utils.checkNotNull(callToAction, "callToAction");
            this.callToAction = callToAction;
            return this;
        }
        
        public PaymentLinkDisplayOptionsUpdate build() {
            return new PaymentLinkDisplayOptionsUpdate(
                title,
                description,
                callToAction);
        }
    }
}
