/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PaymentLinkCustomerOptions {

    /**
     * If true, a billing address is required when completing the payment form.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("requireAddress")
    private Optional<Boolean> requireAddress;

    /**
     * If true, a phone number is required when completing the payment form.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("requirePhone")
    private Optional<Boolean> requirePhone;

    /**
     * Optional free-form metadata for the Moov account that will represent this customer.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private Optional<? extends Map<String, String>> metadata;

    @JsonCreator
    public PaymentLinkCustomerOptions(
            @JsonProperty("requireAddress") Optional<Boolean> requireAddress,
            @JsonProperty("requirePhone") Optional<Boolean> requirePhone,
            @JsonProperty("metadata") Optional<? extends Map<String, String>> metadata) {
        Utils.checkNotNull(requireAddress, "requireAddress");
        Utils.checkNotNull(requirePhone, "requirePhone");
        Utils.checkNotNull(metadata, "metadata");
        this.requireAddress = requireAddress;
        this.requirePhone = requirePhone;
        this.metadata = metadata;
    }
    
    public PaymentLinkCustomerOptions() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * If true, a billing address is required when completing the payment form.
     */
    @JsonIgnore
    public Optional<Boolean> requireAddress() {
        return requireAddress;
    }

    /**
     * If true, a phone number is required when completing the payment form.
     */
    @JsonIgnore
    public Optional<Boolean> requirePhone() {
        return requirePhone;
    }

    /**
     * Optional free-form metadata for the Moov account that will represent this customer.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Map<String, String>> metadata() {
        return (Optional<Map<String, String>>) metadata;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * If true, a billing address is required when completing the payment form.
     */
    public PaymentLinkCustomerOptions withRequireAddress(boolean requireAddress) {
        Utils.checkNotNull(requireAddress, "requireAddress");
        this.requireAddress = Optional.ofNullable(requireAddress);
        return this;
    }

    /**
     * If true, a billing address is required when completing the payment form.
     */
    public PaymentLinkCustomerOptions withRequireAddress(Optional<Boolean> requireAddress) {
        Utils.checkNotNull(requireAddress, "requireAddress");
        this.requireAddress = requireAddress;
        return this;
    }

    /**
     * If true, a phone number is required when completing the payment form.
     */
    public PaymentLinkCustomerOptions withRequirePhone(boolean requirePhone) {
        Utils.checkNotNull(requirePhone, "requirePhone");
        this.requirePhone = Optional.ofNullable(requirePhone);
        return this;
    }

    /**
     * If true, a phone number is required when completing the payment form.
     */
    public PaymentLinkCustomerOptions withRequirePhone(Optional<Boolean> requirePhone) {
        Utils.checkNotNull(requirePhone, "requirePhone");
        this.requirePhone = requirePhone;
        return this;
    }

    /**
     * Optional free-form metadata for the Moov account that will represent this customer.
     */
    public PaymentLinkCustomerOptions withMetadata(Map<String, String> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }

    /**
     * Optional free-form metadata for the Moov account that will represent this customer.
     */
    public PaymentLinkCustomerOptions withMetadata(Optional<? extends Map<String, String>> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkCustomerOptions other = (PaymentLinkCustomerOptions) o;
        return 
            Objects.deepEquals(this.requireAddress, other.requireAddress) &&
            Objects.deepEquals(this.requirePhone, other.requirePhone) &&
            Objects.deepEquals(this.metadata, other.metadata);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            requireAddress,
            requirePhone,
            metadata);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PaymentLinkCustomerOptions.class,
                "requireAddress", requireAddress,
                "requirePhone", requirePhone,
                "metadata", metadata);
    }
    
    public final static class Builder {
 
        private Optional<Boolean> requireAddress = Optional.empty();
 
        private Optional<Boolean> requirePhone = Optional.empty();
 
        private Optional<? extends Map<String, String>> metadata = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * If true, a billing address is required when completing the payment form.
         */
        public Builder requireAddress(boolean requireAddress) {
            Utils.checkNotNull(requireAddress, "requireAddress");
            this.requireAddress = Optional.ofNullable(requireAddress);
            return this;
        }

        /**
         * If true, a billing address is required when completing the payment form.
         */
        public Builder requireAddress(Optional<Boolean> requireAddress) {
            Utils.checkNotNull(requireAddress, "requireAddress");
            this.requireAddress = requireAddress;
            return this;
        }

        /**
         * If true, a phone number is required when completing the payment form.
         */
        public Builder requirePhone(boolean requirePhone) {
            Utils.checkNotNull(requirePhone, "requirePhone");
            this.requirePhone = Optional.ofNullable(requirePhone);
            return this;
        }

        /**
         * If true, a phone number is required when completing the payment form.
         */
        public Builder requirePhone(Optional<Boolean> requirePhone) {
            Utils.checkNotNull(requirePhone, "requirePhone");
            this.requirePhone = requirePhone;
            return this;
        }

        /**
         * Optional free-form metadata for the Moov account that will represent this customer.
         */
        public Builder metadata(Map<String, String> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        /**
         * Optional free-form metadata for the Moov account that will represent this customer.
         */
        public Builder metadata(Optional<? extends Map<String, String>> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }
        
        public PaymentLinkCustomerOptions build() {
            return new PaymentLinkCustomerOptions(
                requireAddress,
                requirePhone,
                metadata);
        }
    }
}
