/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * MxPayload
 * 
 * <p>Describes the account to link to the Moov account using a MX processor token. 
 * 
 * <p>`sandbox` - When linking a bank account to a `sandbox` account using an MX authorization token a default bank account routing number will
 * be used. The following default data will be used to generate the bank account in this flow:
 * 
 * <p>```
 *   RoutingNumber: "123456780",
 *   BankName: "Gringotts Bank"
 * ```
 */
public class MxPayload {

    /**
     * The authorization code of a MX account which allows a processor to retrieve a linked payment account. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment. 
     * The MX authorization code provided must be generated from MX's sandbox environment.
     */
    @JsonProperty("mx")
    private MXAuthorizationCode mx;

    @JsonCreator
    public MxPayload(
            @JsonProperty("mx") MXAuthorizationCode mx) {
        Utils.checkNotNull(mx, "mx");
        this.mx = mx;
    }

    /**
     * The authorization code of a MX account which allows a processor to retrieve a linked payment account. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment. 
     * The MX authorization code provided must be generated from MX's sandbox environment.
     */
    @JsonIgnore
    public MXAuthorizationCode mx() {
        return mx;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The authorization code of a MX account which allows a processor to retrieve a linked payment account. 
     * 
     * <p>`sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment. 
     * The MX authorization code provided must be generated from MX's sandbox environment.
     */
    public MxPayload withMx(MXAuthorizationCode mx) {
        Utils.checkNotNull(mx, "mx");
        this.mx = mx;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MxPayload other = (MxPayload) o;
        return 
            Objects.deepEquals(this.mx, other.mx);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            mx);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MxPayload.class,
                "mx", mx);
    }
    
    public final static class Builder {
 
        private MXAuthorizationCode mx;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The authorization code of a MX account which allows a processor to retrieve a linked payment account. 
         * 
         * <p>`sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment. 
         * The MX authorization code provided must be generated from MX's sandbox environment.
         */
        public Builder mx(MXAuthorizationCode mx) {
            Utils.checkNotNull(mx, "mx");
            this.mx = mx;
            return this;
        }
        
        public MxPayload build() {
            return new MxPayload(
                mx);
        }
    }
}
