/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MoovWalletPaymentMethod implements PaymentMethod {

    /**
     * ID of the payment method.
     */
    @JsonProperty("paymentMethodID")
    private String paymentMethodID;

    @JsonProperty("paymentMethodType")
    private MoovWalletPaymentMethodPaymentMethodType paymentMethodType;

    @JsonProperty("wallet")
    private PaymentMethodsWallet wallet;

    @JsonCreator
    public MoovWalletPaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("paymentMethodType") MoovWalletPaymentMethodPaymentMethodType paymentMethodType,
            @JsonProperty("wallet") PaymentMethodsWallet wallet) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        Utils.checkNotNull(wallet, "wallet");
        this.paymentMethodID = paymentMethodID;
        this.paymentMethodType = paymentMethodType;
        this.wallet = wallet;
    }

    /**
     * ID of the payment method.
     */
    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    @JsonIgnore
    @Override
    public String paymentMethodType() {
        return Utils.discriminatorToString(paymentMethodType);
    }

    @JsonIgnore
    public PaymentMethodsWallet wallet() {
        return wallet;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * ID of the payment method.
     */
    public MoovWalletPaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    public MoovWalletPaymentMethod withPaymentMethodType(MoovWalletPaymentMethodPaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    public MoovWalletPaymentMethod withWallet(PaymentMethodsWallet wallet) {
        Utils.checkNotNull(wallet, "wallet");
        this.wallet = wallet;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoovWalletPaymentMethod other = (MoovWalletPaymentMethod) o;
        return 
            Objects.deepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Objects.deepEquals(this.paymentMethodType, other.paymentMethodType) &&
            Objects.deepEquals(this.wallet, other.wallet);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            paymentMethodID,
            paymentMethodType,
            wallet);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MoovWalletPaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "paymentMethodType", paymentMethodType,
                "wallet", wallet);
    }
    
    public final static class Builder {
 
        private String paymentMethodID;
 
        private MoovWalletPaymentMethodPaymentMethodType paymentMethodType;
 
        private PaymentMethodsWallet wallet;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * ID of the payment method.
         */
        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        public Builder paymentMethodType(MoovWalletPaymentMethodPaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }

        public Builder wallet(PaymentMethodsWallet wallet) {
            Utils.checkNotNull(wallet, "wallet");
            this.wallet = wallet;
            return this;
        }
        
        public MoovWalletPaymentMethod build() {
            return new MoovWalletPaymentMethod(
                paymentMethodID,
                paymentMethodType,
                wallet);
        }
    }
}
