/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * ListFeesFetchRequest
 * 
 * <p>Array of fee IDs to fetch.
 */
public class ListFeesFetchRequest {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("feeIDs")
    private Optional<? extends List<String>> feeIDs;

    @JsonCreator
    public ListFeesFetchRequest(
            @JsonProperty("feeIDs") Optional<? extends List<String>> feeIDs) {
        Utils.checkNotNull(feeIDs, "feeIDs");
        this.feeIDs = feeIDs;
    }
    
    public ListFeesFetchRequest() {
        this(Optional.empty());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> feeIDs() {
        return (Optional<List<String>>) feeIDs;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public ListFeesFetchRequest withFeeIDs(List<String> feeIDs) {
        Utils.checkNotNull(feeIDs, "feeIDs");
        this.feeIDs = Optional.ofNullable(feeIDs);
        return this;
    }

    public ListFeesFetchRequest withFeeIDs(Optional<? extends List<String>> feeIDs) {
        Utils.checkNotNull(feeIDs, "feeIDs");
        this.feeIDs = feeIDs;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListFeesFetchRequest other = (ListFeesFetchRequest) o;
        return 
            Objects.deepEquals(this.feeIDs, other.feeIDs);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            feeIDs);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListFeesFetchRequest.class,
                "feeIDs", feeIDs);
    }
    
    public final static class Builder {
 
        private Optional<? extends List<String>> feeIDs = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder feeIDs(List<String> feeIDs) {
            Utils.checkNotNull(feeIDs, "feeIDs");
            this.feeIDs = Optional.ofNullable(feeIDs);
            return this;
        }

        public Builder feeIDs(Optional<? extends List<String>> feeIDs) {
            Utils.checkNotNull(feeIDs, "feeIDs");
            this.feeIDs = feeIDs;
            return this;
        }
        
        public ListFeesFetchRequest build() {
            return new ListFeesFetchRequest(
                feeIDs);
        }
    }
}
