/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class LinkedApplePayPaymentMethod {

    /**
     * The new payment method's ID.
     */
    @JsonProperty("paymentMethodID")
    private String paymentMethodID;

    /**
     * The payment method type that represents a payment rail and directionality
     */
    @JsonProperty("paymentMethodType")
    private PaymentMethodType paymentMethodType;

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    @JsonProperty("applePay")
    private ApplePayResponse applePay;

    @JsonCreator
    public LinkedApplePayPaymentMethod(
            @JsonProperty("paymentMethodID") String paymentMethodID,
            @JsonProperty("paymentMethodType") PaymentMethodType paymentMethodType,
            @JsonProperty("applePay") ApplePayResponse applePay) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        Utils.checkNotNull(applePay, "applePay");
        this.paymentMethodID = paymentMethodID;
        this.paymentMethodType = paymentMethodType;
        this.applePay = applePay;
    }

    /**
     * The new payment method's ID.
     */
    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    /**
     * The payment method type that represents a payment rail and directionality
     */
    @JsonIgnore
    public PaymentMethodType paymentMethodType() {
        return paymentMethodType;
    }

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    @JsonIgnore
    public ApplePayResponse applePay() {
        return applePay;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The new payment method's ID.
     */
    public LinkedApplePayPaymentMethod withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    /**
     * The payment method type that represents a payment rail and directionality
     */
    public LinkedApplePayPaymentMethod withPaymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    /**
     * Describes an Apple Pay token on a Moov account.
     */
    public LinkedApplePayPaymentMethod withApplePay(ApplePayResponse applePay) {
        Utils.checkNotNull(applePay, "applePay");
        this.applePay = applePay;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedApplePayPaymentMethod other = (LinkedApplePayPaymentMethod) o;
        return 
            Objects.deepEquals(this.paymentMethodID, other.paymentMethodID) &&
            Objects.deepEquals(this.paymentMethodType, other.paymentMethodType) &&
            Objects.deepEquals(this.applePay, other.applePay);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            paymentMethodID,
            paymentMethodType,
            applePay);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkedApplePayPaymentMethod.class,
                "paymentMethodID", paymentMethodID,
                "paymentMethodType", paymentMethodType,
                "applePay", applePay);
    }
    
    public final static class Builder {
 
        private String paymentMethodID;
 
        private PaymentMethodType paymentMethodType;
 
        private ApplePayResponse applePay;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The new payment method's ID.
         */
        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        /**
         * The payment method type that represents a payment rail and directionality
         */
        public Builder paymentMethodType(PaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }

        /**
         * Describes an Apple Pay token on a Moov account.
         */
        public Builder applePay(ApplePayResponse applePay) {
            Utils.checkNotNull(applePay, "applePay");
            this.applePay = applePay;
            return this;
        }
        
        public LinkedApplePayPaymentMethod build() {
            return new LinkedApplePayPaymentMethod(
                paymentMethodID,
                paymentMethodType,
                applePay);
        }
    }
}
