/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * LinkApplePaymentData
 * 
 * <p>Contains the encrypted payment data.
 * 
 * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916115-paymentdata) 
 *   for more information.
 */
public class LinkApplePaymentData {

    /**
     * Specifies the encryption used for the payment token ("EC_v1" or "RSA_v1").
     */
    @JsonProperty("version")
    private String version;

    /**
     * The encrypted, base64-encoded payment data.
     */
    @JsonProperty("data")
    private String data;

    /**
     * A base64 encoded signature of the payment and header data.
     */
    @JsonProperty("signature")
    private String signature;

    /**
     * Information needed to decrypt Apple Pay payment data.
     * 
     * <p>Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values) 
     * for more information.
     */
    @JsonProperty("header")
    private ApplePayHeader header;

    @JsonCreator
    public LinkApplePaymentData(
            @JsonProperty("version") String version,
            @JsonProperty("data") String data,
            @JsonProperty("signature") String signature,
            @JsonProperty("header") ApplePayHeader header) {
        Utils.checkNotNull(version, "version");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(signature, "signature");
        Utils.checkNotNull(header, "header");
        this.version = version;
        this.data = data;
        this.signature = signature;
        this.header = header;
    }

    /**
     * Specifies the encryption used for the payment token ("EC_v1" or "RSA_v1").
     */
    @JsonIgnore
    public String version() {
        return version;
    }

    /**
     * The encrypted, base64-encoded payment data.
     */
    @JsonIgnore
    public String data() {
        return data;
    }

    /**
     * A base64 encoded signature of the payment and header data.
     */
    @JsonIgnore
    public String signature() {
        return signature;
    }

    /**
     * Information needed to decrypt Apple Pay payment data.
     * 
     * <p>Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values) 
     * for more information.
     */
    @JsonIgnore
    public ApplePayHeader header() {
        return header;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Specifies the encryption used for the payment token ("EC_v1" or "RSA_v1").
     */
    public LinkApplePaymentData withVersion(String version) {
        Utils.checkNotNull(version, "version");
        this.version = version;
        return this;
    }

    /**
     * The encrypted, base64-encoded payment data.
     */
    public LinkApplePaymentData withData(String data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    /**
     * A base64 encoded signature of the payment and header data.
     */
    public LinkApplePaymentData withSignature(String signature) {
        Utils.checkNotNull(signature, "signature");
        this.signature = signature;
        return this;
    }

    /**
     * Information needed to decrypt Apple Pay payment data.
     * 
     * <p>Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values) 
     * for more information.
     */
    public LinkApplePaymentData withHeader(ApplePayHeader header) {
        Utils.checkNotNull(header, "header");
        this.header = header;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkApplePaymentData other = (LinkApplePaymentData) o;
        return 
            Objects.deepEquals(this.version, other.version) &&
            Objects.deepEquals(this.data, other.data) &&
            Objects.deepEquals(this.signature, other.signature) &&
            Objects.deepEquals(this.header, other.header);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            version,
            data,
            signature,
            header);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkApplePaymentData.class,
                "version", version,
                "data", data,
                "signature", signature,
                "header", header);
    }
    
    public final static class Builder {
 
        private String version;
 
        private String data;
 
        private String signature;
 
        private ApplePayHeader header;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Specifies the encryption used for the payment token ("EC_v1" or "RSA_v1").
         */
        public Builder version(String version) {
            Utils.checkNotNull(version, "version");
            this.version = version;
            return this;
        }

        /**
         * The encrypted, base64-encoded payment data.
         */
        public Builder data(String data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        /**
         * A base64 encoded signature of the payment and header data.
         */
        public Builder signature(String signature) {
            Utils.checkNotNull(signature, "signature");
            this.signature = signature;
            return this;
        }

        /**
         * Information needed to decrypt Apple Pay payment data.
         * 
         * <p>Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values) 
         * for more information.
         */
        public Builder header(ApplePayHeader header) {
            Utils.checkNotNull(header, "header");
            this.header = header;
            return this;
        }
        
        public LinkApplePaymentData build() {
            return new LinkApplePaymentData(
                version,
                data,
                signature,
                header);
        }
    }
}
