/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import java.util.Optional;

/**
 * LinkApplePay
 * 
 * <p>The JSON structure returned from Apple Pay when authorizing a payment session.
 * 
 * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypayment) 
 *   for more information.
 */
public class LinkApplePay {

    /**
     * Contains the user's payment information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken) 
     *   for more information.
     */
    @JsonProperty("token")
    private LinkApplePayToken token;

    /**
     * Billing contact information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
     *   for more information.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("billingContact")
    private Optional<? extends AppleBillingContact> billingContact;

    @JsonCreator
    public LinkApplePay(
            @JsonProperty("token") LinkApplePayToken token,
            @JsonProperty("billingContact") Optional<? extends AppleBillingContact> billingContact) {
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(billingContact, "billingContact");
        this.token = token;
        this.billingContact = billingContact;
    }
    
    public LinkApplePay(
            LinkApplePayToken token) {
        this(token, Optional.empty());
    }

    /**
     * Contains the user's payment information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken) 
     *   for more information.
     */
    @JsonIgnore
    public LinkApplePayToken token() {
        return token;
    }

    /**
     * Billing contact information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
     *   for more information.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AppleBillingContact> billingContact() {
        return (Optional<AppleBillingContact>) billingContact;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Contains the user's payment information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken) 
     *   for more information.
     */
    public LinkApplePay withToken(LinkApplePayToken token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    /**
     * Billing contact information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
     *   for more information.
     */
    public LinkApplePay withBillingContact(AppleBillingContact billingContact) {
        Utils.checkNotNull(billingContact, "billingContact");
        this.billingContact = Optional.ofNullable(billingContact);
        return this;
    }

    /**
     * Billing contact information as returned from Apple Pay.
     * 
     * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
     *   for more information.
     */
    public LinkApplePay withBillingContact(Optional<? extends AppleBillingContact> billingContact) {
        Utils.checkNotNull(billingContact, "billingContact");
        this.billingContact = billingContact;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkApplePay other = (LinkApplePay) o;
        return 
            Objects.deepEquals(this.token, other.token) &&
            Objects.deepEquals(this.billingContact, other.billingContact);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            token,
            billingContact);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkApplePay.class,
                "token", token,
                "billingContact", billingContact);
    }
    
    public final static class Builder {
 
        private LinkApplePayToken token;
 
        private Optional<? extends AppleBillingContact> billingContact = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Contains the user's payment information as returned from Apple Pay.
         * 
         * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken) 
         *   for more information.
         */
        public Builder token(LinkApplePayToken token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        /**
         * Billing contact information as returned from Apple Pay.
         * 
         * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
         *   for more information.
         */
        public Builder billingContact(AppleBillingContact billingContact) {
            Utils.checkNotNull(billingContact, "billingContact");
            this.billingContact = Optional.ofNullable(billingContact);
            return this;
        }

        /**
         * Billing contact information as returned from Apple Pay.
         * 
         * <p>  Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymentcontact) 
         *   for more information.
         */
        public Builder billingContact(Optional<? extends AppleBillingContact> billingContact) {
            Utils.checkNotNull(billingContact, "billingContact");
            this.billingContact = billingContact;
            return this;
        }
        
        public LinkApplePay build() {
            return new LinkApplePay(
                token,
                billingContact);
        }
    }
}
