/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * LinkAccountTerminalApplication
 * 
 * <p>Describes a request to link an account with a terminal application.
 */
public class LinkAccountTerminalApplication {

    /**
     * ID of the terminal application.
     */
    @JsonProperty("terminalApplicationID")
    private String terminalApplicationID;

    @JsonCreator
    public LinkAccountTerminalApplication(
            @JsonProperty("terminalApplicationID") String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
    }

    /**
     * ID of the terminal application.
     */
    @JsonIgnore
    public String terminalApplicationID() {
        return terminalApplicationID;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * ID of the terminal application.
     */
    public LinkAccountTerminalApplication withTerminalApplicationID(String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkAccountTerminalApplication other = (LinkAccountTerminalApplication) o;
        return 
            Objects.deepEquals(this.terminalApplicationID, other.terminalApplicationID);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            terminalApplicationID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkAccountTerminalApplication.class,
                "terminalApplicationID", terminalApplicationID);
    }
    
    public final static class Builder {
 
        private String terminalApplicationID;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * ID of the terminal application.
         */
        public Builder terminalApplicationID(String terminalApplicationID) {
            Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
            this.terminalApplicationID = terminalApplicationID;
            return this;
        }
        
        public LinkAccountTerminalApplication build() {
            return new LinkAccountTerminalApplication(
                terminalApplicationID);
        }
    }
}
