/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * JSONWebKey
 * 
 * <p>Describes an [RFC7517](https://datatracker.ietf.org/doc/html/rfc7517) web key.
 */
public class JSONWebKey {

    /**
     * The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct').
     */
    @JsonProperty("kty")
    private String kty;

    /**
     * The intended use of the key. 'sig' for signature, 'enc' for encryption.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("use")
    private Optional<? extends Use> use;

    /**
     * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("key_ops")
    private Optional<? extends List<String>> keyOps;

    /**
     * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("alg")
    private Optional<String> alg;

    /**
     * A unique identifier for the key.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("kid")
    private Optional<String> kid;

    /**
     * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("crv")
    private Optional<String> crv;

    /**
     * The x coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("x")
    private Optional<String> x;

    /**
     * The y coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("y")
    private Optional<String> y;

    /**
     * The modulus value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("n")
    private Optional<String> n;

    /**
     * The exponent value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("e")
    private Optional<String> e;

    @JsonCreator
    public JSONWebKey(
            @JsonProperty("kty") String kty,
            @JsonProperty("use") Optional<? extends Use> use,
            @JsonProperty("key_ops") Optional<? extends List<String>> keyOps,
            @JsonProperty("alg") Optional<String> alg,
            @JsonProperty("kid") Optional<String> kid,
            @JsonProperty("crv") Optional<String> crv,
            @JsonProperty("x") Optional<String> x,
            @JsonProperty("y") Optional<String> y,
            @JsonProperty("n") Optional<String> n,
            @JsonProperty("e") Optional<String> e) {
        Utils.checkNotNull(kty, "kty");
        Utils.checkNotNull(use, "use");
        Utils.checkNotNull(keyOps, "keyOps");
        Utils.checkNotNull(alg, "alg");
        Utils.checkNotNull(kid, "kid");
        Utils.checkNotNull(crv, "crv");
        Utils.checkNotNull(x, "x");
        Utils.checkNotNull(y, "y");
        Utils.checkNotNull(n, "n");
        Utils.checkNotNull(e, "e");
        this.kty = kty;
        this.use = use;
        this.keyOps = keyOps;
        this.alg = alg;
        this.kid = kid;
        this.crv = crv;
        this.x = x;
        this.y = y;
        this.n = n;
        this.e = e;
    }
    
    public JSONWebKey(
            String kty) {
        this(kty, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct').
     */
    @JsonIgnore
    public String kty() {
        return kty;
    }

    /**
     * The intended use of the key. 'sig' for signature, 'enc' for encryption.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Use> use() {
        return (Optional<Use>) use;
    }

    /**
     * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> keyOps() {
        return (Optional<List<String>>) keyOps;
    }

    /**
     * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
     */
    @JsonIgnore
    public Optional<String> alg() {
        return alg;
    }

    /**
     * A unique identifier for the key.
     */
    @JsonIgnore
    public Optional<String> kid() {
        return kid;
    }

    /**
     * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonIgnore
    public Optional<String> crv() {
        return crv;
    }

    /**
     * The x coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonIgnore
    public Optional<String> x() {
        return x;
    }

    /**
     * The y coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    @JsonIgnore
    public Optional<String> y() {
        return y;
    }

    /**
     * The modulus value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    @JsonIgnore
    public Optional<String> n() {
        return n;
    }

    /**
     * The exponent value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    @JsonIgnore
    public Optional<String> e() {
        return e;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct').
     */
    public JSONWebKey withKty(String kty) {
        Utils.checkNotNull(kty, "kty");
        this.kty = kty;
        return this;
    }

    /**
     * The intended use of the key. 'sig' for signature, 'enc' for encryption.
     */
    public JSONWebKey withUse(Use use) {
        Utils.checkNotNull(use, "use");
        this.use = Optional.ofNullable(use);
        return this;
    }

    /**
     * The intended use of the key. 'sig' for signature, 'enc' for encryption.
     */
    public JSONWebKey withUse(Optional<? extends Use> use) {
        Utils.checkNotNull(use, "use");
        this.use = use;
        return this;
    }

    /**
     * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
     */
    public JSONWebKey withKeyOps(List<String> keyOps) {
        Utils.checkNotNull(keyOps, "keyOps");
        this.keyOps = Optional.ofNullable(keyOps);
        return this;
    }

    /**
     * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
     */
    public JSONWebKey withKeyOps(Optional<? extends List<String>> keyOps) {
        Utils.checkNotNull(keyOps, "keyOps");
        this.keyOps = keyOps;
        return this;
    }

    /**
     * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
     */
    public JSONWebKey withAlg(String alg) {
        Utils.checkNotNull(alg, "alg");
        this.alg = Optional.ofNullable(alg);
        return this;
    }

    /**
     * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
     */
    public JSONWebKey withAlg(Optional<String> alg) {
        Utils.checkNotNull(alg, "alg");
        this.alg = alg;
        return this;
    }

    /**
     * A unique identifier for the key.
     */
    public JSONWebKey withKid(String kid) {
        Utils.checkNotNull(kid, "kid");
        this.kid = Optional.ofNullable(kid);
        return this;
    }

    /**
     * A unique identifier for the key.
     */
    public JSONWebKey withKid(Optional<String> kid) {
        Utils.checkNotNull(kid, "kid");
        this.kid = kid;
        return this;
    }

    /**
     * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withCrv(String crv) {
        Utils.checkNotNull(crv, "crv");
        this.crv = Optional.ofNullable(crv);
        return this;
    }

    /**
     * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withCrv(Optional<String> crv) {
        Utils.checkNotNull(crv, "crv");
        this.crv = crv;
        return this;
    }

    /**
     * The x coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withX(String x) {
        Utils.checkNotNull(x, "x");
        this.x = Optional.ofNullable(x);
        return this;
    }

    /**
     * The x coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withX(Optional<String> x) {
        Utils.checkNotNull(x, "x");
        this.x = x;
        return this;
    }

    /**
     * The y coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withY(String y) {
        Utils.checkNotNull(y, "y");
        this.y = Optional.ofNullable(y);
        return this;
    }

    /**
     * The y coordinate for Elliptic Curve keys.
     * 
     * <p>This field is required when `kty` is 'EC'.
     */
    public JSONWebKey withY(Optional<String> y) {
        Utils.checkNotNull(y, "y");
        this.y = y;
        return this;
    }

    /**
     * The modulus value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    public JSONWebKey withN(String n) {
        Utils.checkNotNull(n, "n");
        this.n = Optional.ofNullable(n);
        return this;
    }

    /**
     * The modulus value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    public JSONWebKey withN(Optional<String> n) {
        Utils.checkNotNull(n, "n");
        this.n = n;
        return this;
    }

    /**
     * The exponent value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    public JSONWebKey withE(String e) {
        Utils.checkNotNull(e, "e");
        this.e = Optional.ofNullable(e);
        return this;
    }

    /**
     * The exponent value for RSA keys.
     * 
     * <p>This field is required when `kty` is 'RSA'.
     */
    public JSONWebKey withE(Optional<String> e) {
        Utils.checkNotNull(e, "e");
        this.e = e;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JSONWebKey other = (JSONWebKey) o;
        return 
            Objects.deepEquals(this.kty, other.kty) &&
            Objects.deepEquals(this.use, other.use) &&
            Objects.deepEquals(this.keyOps, other.keyOps) &&
            Objects.deepEquals(this.alg, other.alg) &&
            Objects.deepEquals(this.kid, other.kid) &&
            Objects.deepEquals(this.crv, other.crv) &&
            Objects.deepEquals(this.x, other.x) &&
            Objects.deepEquals(this.y, other.y) &&
            Objects.deepEquals(this.n, other.n) &&
            Objects.deepEquals(this.e, other.e);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            kty,
            use,
            keyOps,
            alg,
            kid,
            crv,
            x,
            y,
            n,
            e);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JSONWebKey.class,
                "kty", kty,
                "use", use,
                "keyOps", keyOps,
                "alg", alg,
                "kid", kid,
                "crv", crv,
                "x", x,
                "y", y,
                "n", n,
                "e", e);
    }
    
    public final static class Builder {
 
        private String kty;
 
        private Optional<? extends Use> use = Optional.empty();
 
        private Optional<? extends List<String>> keyOps = Optional.empty();
 
        private Optional<String> alg = Optional.empty();
 
        private Optional<String> kid = Optional.empty();
 
        private Optional<String> crv = Optional.empty();
 
        private Optional<String> x = Optional.empty();
 
        private Optional<String> y = Optional.empty();
 
        private Optional<String> n = Optional.empty();
 
        private Optional<String> e = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct').
         */
        public Builder kty(String kty) {
            Utils.checkNotNull(kty, "kty");
            this.kty = kty;
            return this;
        }

        /**
         * The intended use of the key. 'sig' for signature, 'enc' for encryption.
         */
        public Builder use(Use use) {
            Utils.checkNotNull(use, "use");
            this.use = Optional.ofNullable(use);
            return this;
        }

        /**
         * The intended use of the key. 'sig' for signature, 'enc' for encryption.
         */
        public Builder use(Optional<? extends Use> use) {
            Utils.checkNotNull(use, "use");
            this.use = use;
            return this;
        }

        /**
         * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
         */
        public Builder keyOps(List<String> keyOps) {
            Utils.checkNotNull(keyOps, "keyOps");
            this.keyOps = Optional.ofNullable(keyOps);
            return this;
        }

        /**
         * The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'.
         */
        public Builder keyOps(Optional<? extends List<String>> keyOps) {
            Utils.checkNotNull(keyOps, "keyOps");
            this.keyOps = keyOps;
            return this;
        }

        /**
         * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
         */
        public Builder alg(String alg) {
            Utils.checkNotNull(alg, "alg");
            this.alg = Optional.ofNullable(alg);
            return this;
        }

        /**
         * The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'.
         */
        public Builder alg(Optional<String> alg) {
            Utils.checkNotNull(alg, "alg");
            this.alg = alg;
            return this;
        }

        /**
         * A unique identifier for the key.
         */
        public Builder kid(String kid) {
            Utils.checkNotNull(kid, "kid");
            this.kid = Optional.ofNullable(kid);
            return this;
        }

        /**
         * A unique identifier for the key.
         */
        public Builder kid(Optional<String> kid) {
            Utils.checkNotNull(kid, "kid");
            this.kid = kid;
            return this;
        }

        /**
         * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder crv(String crv) {
            Utils.checkNotNull(crv, "crv");
            this.crv = Optional.ofNullable(crv);
            return this;
        }

        /**
         * The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder crv(Optional<String> crv) {
            Utils.checkNotNull(crv, "crv");
            this.crv = crv;
            return this;
        }

        /**
         * The x coordinate for Elliptic Curve keys.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder x(String x) {
            Utils.checkNotNull(x, "x");
            this.x = Optional.ofNullable(x);
            return this;
        }

        /**
         * The x coordinate for Elliptic Curve keys.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder x(Optional<String> x) {
            Utils.checkNotNull(x, "x");
            this.x = x;
            return this;
        }

        /**
         * The y coordinate for Elliptic Curve keys.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder y(String y) {
            Utils.checkNotNull(y, "y");
            this.y = Optional.ofNullable(y);
            return this;
        }

        /**
         * The y coordinate for Elliptic Curve keys.
         * 
         * <p>This field is required when `kty` is 'EC'.
         */
        public Builder y(Optional<String> y) {
            Utils.checkNotNull(y, "y");
            this.y = y;
            return this;
        }

        /**
         * The modulus value for RSA keys.
         * 
         * <p>This field is required when `kty` is 'RSA'.
         */
        public Builder n(String n) {
            Utils.checkNotNull(n, "n");
            this.n = Optional.ofNullable(n);
            return this;
        }

        /**
         * The modulus value for RSA keys.
         * 
         * <p>This field is required when `kty` is 'RSA'.
         */
        public Builder n(Optional<String> n) {
            Utils.checkNotNull(n, "n");
            this.n = n;
            return this;
        }

        /**
         * The exponent value for RSA keys.
         * 
         * <p>This field is required when `kty` is 'RSA'.
         */
        public Builder e(String e) {
            Utils.checkNotNull(e, "e");
            this.e = Optional.ofNullable(e);
            return this;
        }

        /**
         * The exponent value for RSA keys.
         * 
         * <p>This field is required when `kty` is 'RSA'.
         */
        public Builder e(Optional<String> e) {
            Utils.checkNotNull(e, "e");
            this.e = e;
            return this;
        }
        
        public JSONWebKey build() {
            return new JSONWebKey(
                kty,
                use,
                keyOps,
                alg,
                kid,
                crv,
                x,
                y,
                n,
                e);
        }
    }
}
